package Lire::AsciiDlf::DlfInfo;

use strict;

use Carp;

=pod

=head1 NAME

Lire::DlfInfo - Deprecated module.

=head1 SYNOPSIS

    # Deprecated interface.

=head1 DESCRIPTION

This module is deprecated in favor of the Lire::DlfStore and
Lire::DlfStream interfaces.

=cut

sub new {
    my $proto = shift;
    my $class = ref( $proto) || $proto;

    my $stream = $_[0];
    croak "invalid stream parameter ($stream): must be of type Lire::DlfStream"
      unless UNIVERSAL::isa( $stream, "Lire::DlfStream" );

    return bless { 'stream' => $stream, }, $class;
}

sub start_time {
    return $_[0]{'stream'}->start_time;
}

sub end_time {
    return $_[0]{'stream'}->start_time;
}

sub record_count {
    return $_[0]{'stream'}->nrecords;
}

sub is_field_available {
    my ( $self, $field ) = @_;

    carp "uses of deprecated is_field_available()";
    return 1;
}

sub unavail_fields {
    carp "uses of deprecated is_field_available()";

    return ();
}

# keep perl happy
1;

__END__

=pod

=head1 SEE ALSO

Lire::DlfStream(3pm), Lire::DlfStore(3pm)

=head1 VERSION

$Id: DlfInfo.pm,v 1.12 2004/03/26 00:27:34 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2002-2003 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut

