package Lire::Config::ConfigSpec;

use strict;

use base qw/ Lire::Config::CompoundSpec /;

use Carp;

use Lire::Utils qw/ check_param /;

=pod

=head1 Lire::Config::ConfigSpec

Describes a type of configuration variables that contain a configuration.
That is, not the entire configuration but a part, such as a single
template or the list of global configuration items.

=cut

sub new {
    return shift->SUPER::new( 'name' => 'config', @_ );
}

sub instance {
    my $self = shift;
    return new Lire::Config::Dictionary( @_, 'spec' => $self );
}

sub instance_class_ {
    return "Lire::Config::Dictionary";
}

=pod

=head2 components_by_section( $section )

Returns in an array ref all the contained parameter specifications
that are in the requested section. The parameters are sorted alphabetically.

=cut

sub components_by_section {
    my ( $self, $section)  = @_;

    check_param( $section, 'section' );

    my $comps = [];

    my @components = $self->components();
    foreach my $comp ( @components ) {
        push @$comps, $comp
          if ( defined $comp->{'section'} && $section eq $comp->{'section'} );
    }

    return $comps;
}

=pod

=head2 xml_file( [ $file ] )

Returns the XML filename from which this specification was loaded. If the
$file parameter is set, the associated filename will be changed.

=cut
sub xml_file {
    my ( $self, $file ) = @_;

    $self->{'xml_file'} = $file if defined $file;

    return $self->{'xml_file'};
}

1;
