package Lire::Config::ObjectSpec;

use strict;

use base qw/ Lire::Config::CompoundSpec /;

use Carp;

use Lire::Config::Object;
use Lire::Utils qw/ check_param /;

=pod

=head1 Lire::Config::ObjectSpec

Describes a type of configuration variables that will be used to instantiate
an object in a class which defines a new_from_config() constructor.

=cut

sub new {
    my ( $class, %args ) = @_;

    check_param( $args{'class'}, 'class' );

    my $self = $class->SUPER::new( %args );
    $self->{'class'} = $args{'class'};

    return $self;
}

sub class {
    return $_[0]{'class'}
}

sub instance {
    my $self = shift;
    return new Lire::Config::Object( @_, 'spec' => $self );
}

1;
__END__

=pod

=head1 VERSION

$Id: ObjectSpec.pm,v 1.3 2004/03/26 00:27:33 wsourdeau Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
