package Lire::UI::IntegerWidget;

use strict;

use base qw/ Curses::UI::Container Lire::UI::Widget /;

use Curses::UI::Common;

use Carp;
use vars qw/@CARP_NOT/;
use Lire::Utils qw/ check_object_param /;

@CARP_NOT = qw/Curses::UI::Container/;

sub new {
    my $class = shift;
    my %userargs = @_;
    keys_to_lowercase(\%userargs);

    check_object_param( $userargs{'value'}, 'value',
                        'Lire::Config::Scalar' );

    my %args = (
                '-height' => 1,
                %userargs,
                '-releasefocus' => 1,
                '-border' => 0,
               );

    my $self =  $class->Curses::UI::Container::new( %args );
    my $text_entry = $self->add( 'text_entry', 'TextEntry',
                                 '-sbborder' => 1,
                                 '-padright' => 15,
                                 '-text' => $userargs{'value'}->get(),
                                 '-regexp' => '/^[0-9]*$/',
                                 '-onchange' => \&_on_change_cb );

    my $dec_button = $self->add( 'dec_button', 'Buttonbox',
                                 '-width' => 5,
                                 '-x' => -10,
                                 '-buttons' =>
                                 [ { '-label' => ' [<] ',
                                     '-onpress' => sub {
                                         $self->_on_dec_press_cb_helper()
                                     } } ] );
    my $inc_button = $self->add( 'inc_button', 'Buttonbox',
                                 '-width' => 5,
                                 '-x' => -5,
                                 '-buttons' =>
                                 [ { '-label' => ' [>] ',
                                     '-onpress' => sub {
                                         $self->_on_inc_press_cb_helper()
                                     } } ] );

    return $self;
}

sub refresh_view {
    my $self = $_[0];

    my $text_entry = $self->getobj( 'text_entry' );
    $text_entry->text( $self->{'value'}->get() );

    return;
}

sub _on_dec_press_cb_helper {
    my $self = $_[0];

    my $value = $self->{'value'}->get() || 0;
    $self->{'value'}->set( $value - 1 );
    $self->refresh_view();

    return;
}

sub _on_inc_press_cb_helper {
    my $self = $_[0];

    my $value = $self->{'value'}->get() || 0;
    $self->{'value'}->set( $value + 1 );
    $self->refresh_view();

    return;
}

# callbacks
sub _on_change_cb {
    my $text_entry = $_[0];

    my $self = $text_entry->parent();
    $self->{'value'}->set( $text_entry->{'-text'} );

    return;
}

1;
