package Lire::UI::Widget;

use strict;

use Carp;
use Curses::UI::Common;
use Lire::Utils qw/ check_object_param /;

use base qw/ Curses::UI::Widget /;

use vars qw/@CARP_NOT/;
@CARP_NOT = qw/Curses::UI::Container/;

=pod

=head1 NAME

Lire::UI::Widget - Custom widgets

=head1 SYNOPSIS

  use Curses::UI;
  use Lire::Config;

  Lire::Config->init();
  my $ui = new Curses::UI();
  my $window = $ui->add( 'window', 'Window' );
  my $widget = $window->add( 'widget', 'Lire::UI::Widget',
                             'value' => Lire::Config->get_var( 'name' ));

=head1 DESCRIPTION

XXX FIXME

=cut

use vars qw/ %widget_table /;

%widget_table = ( 'Lire::Config::StringSpec' => 'Lire::UI::StringWidget',
                  'Lire::Config::IntegerSpec' => 'Lire::UI::IntegerWidget',
                  'Lire::Config::BooleanSpec' => 'Lire::UI::BoolWidget',
                  'Lire::Config::DirectorySpec'=>'Lire::UI::DirectoryWidget',
                  'Lire::Config::FileSpec' => 'Lire::UI::FileWidget',
                  'Lire::Config::CommandSpec' => 'Lire::UI::CommandWidget',
                  'Lire::Config::ExecutableSpec'=>'Lire::UI::ExecutableWidget',
                  'Lire::Config::SelectSpec' => 'Lire::UI::SelectWidget',
                  'Lire::Config::ListSpec' => 'Lire::UI::ListWidget',
                  'Lire::Config::PluginSpec' => 'Lire::UI::PluginWidget',
                  'Lire::Config::DlfConverterSpec' => 'Lire::UI::PluginWidget',
                  'Lire::Config::DlfSchemaSpec' => 'Lire::UI::SelectWidget',
                  'Lire::Config::RecordSpec' => 'Lire::UI::CompoundWidget',
                  'Lire::Config::ObjectSpec' => 'Lire::UI::CompoundWidget',
                );

sub new {
    my $class = shift;
    my %userargs = @_;
    keys_to_lowercase(\%userargs);

    check_object_param( $userargs{'value'}, 'value', 'Lire::Config::Value' );

    my $spec_type = ref( $userargs{'value'}->spec() );
    croak "no widget type defined for values of type '$spec_type'"
      unless exists( $widget_table{$spec_type} );

    my $widget_class = $widget_table{$spec_type};
    eval "use $widget_class;";
    die if $@;

    return $widget_class->new( %userargs );
}

sub refresh_view {
    croak "unimplemented refresh_view() in ", ref $_[0];
}

package Lire::UI::DummyWidget;

$INC{'Lire/UI/DummyWidget.pm'} = __FILE__;

use base qw/Curses::UI::TextViewer/;

use Carp;

sub new {
    my ( $class, %args ) = @_;

    return $class->SUPER::new( %args, '-text' => $args{'value'}->get() );
}

sub refresh_view {
    $_[0]->text( $_[0]->{'value'}->get() );
}

# keep perl happy
1;

__END__

=pod

=head1 SEE ALSO

Lire::UI(3pm)

=head1 VERSION

$Id: Widget.pm,v 1.18 2004/03/26 00:27:33 wsourdeau Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
