#
# $Id: Attack.pm,v 1.8 2002/06/13 21:56:01 vanbaal Exp $
#
# Copyright (C) 2001 Stichting LogReport Foundation <logreport@logreport.org>
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html or write to the Free Software
#     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
package Lire::WWW::Filename::Attack;

use strict;
use vars qw/ $REVISION/;

{
    $REVISION  = '$Id: Attack.pm,v 1.8 2002/06/13 21:56:01 vanbaal Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %AttackHash = (
  # attacks on IIS servers
  # this sucks... this could be done much better!
  # Nimda, for example, uses several exploits, of which
  # the Code Red II Back Door attack...
  "/default.ida" => "Code Red",
  "/msadc/msadcs.dll" => "MDAC Attack",
  "asp+.htr" => ".htr Exploit",
  "asa+.htr" => ".htr Exploit",
  "root.exe?/c+dir" => "Code Red II Back Door Attack",
  "/winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
);

my %CompiledHash = map { $_ => qr/$_/; } keys %AttackHash;

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getAttack {
    my ( $filename ) = @_;

    foreach my $attack (keys %AttackHash) {
        if ( $filename =~ /$CompiledHash{$attack}/ ) {
            return $AttackHash{$attack};
        }
    }
    return undef;
}

1;

