package tests::ReportGeneratorTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::ReportConfig;
use Lire::ReportGenerator;
use Lire::ReportParser::ReportBuilder;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->set_up_tz( 'EST5' );

    $self->{'cfg'}{'lr_scale_numbers'} = 0;
    $self->{'cfg'}{'lr_scale_bytes'} = 1;
    $self->{'cfg'}{'lr_scale_seconds'} = 1;

    $self->{'cfg'}{'lr_reports_path'} = [ $self->{'testdir'} . "/reports" ];
    $self->{'cfg'}{'lr_filters_path'} = [ $self->{'testdir'} . "/filters" ];


    $self->set_up_test_store();

    $self->{'report_cfg'} = new_from_file Lire::ReportConfig( 'test', $self->{'testdir'} . "/data/test.cfg" );

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_new {
    my $self = $_[0];

    $self->assert_dies( qr/'report_cfg' parameter should be a 'Lire::ReportConfig' instance/,
                        sub { new Lire::ReportGenerator( 'test' ) } );

    $self->assert_dies(qr/'store' parameter should be a 'Lire::DlfStore' instance, not/,
                       sub { new Lire::ReportGenerator( $self->{'report_cfg'},
                                                        {} ) },);

}

sub test_generate_report {
    my $self = $_[0];

    my $parser = new Lire::ReportParser::ReportBuilder();
    my $report_e = $parser->parsefile( "$self->{'testdir'}/data/test-sqlite.xml" );

    my $gen = new Lire::ReportGenerator( $self->{'report_cfg'},
                                         $self->{'store'} );
    my $report_t = $gen->generate_report();
    $self->assert_isa( 'Lire::Report', $report_t );

    # The difference in these fields are normal
    $report_t->{'date'} = $report_e->{'date'};
    $report_t->generator( $report_e->generator() );

    $self->assert_deep_equals( $report_e, $report_t );
}

1;
