package tests::ReportParserTest;

use base qw/Lire::Test::TestCase/;

use Lire::ReportParser;
use Lire::Report::TableInfo;

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->{'parser'} = new Lire::ReportParser();
    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    return $self;
}

sub test_column_info_start {
    my $self = $_[0];

    my $info = new Lire::Report::TableInfo();
    push @{$self->{'parser'}{'lrp_curr_group_info'}}, $info;

    my %attr = (
                'name' => 'file',
                'class' => 'categorical',
                'type' => 'string',
                'label' => 'A File',
                'col-start' => 1,
                'col-end' => 1,
                'col-width' => 20,
                'max-chars' => 20,
                'avg-chars' => 8,
                );
    $self->{'parser'}->column_info_start( %attr );

    my $col_info = $info->column_info_by_name( 'file' );
    $self->assert_not_null( $col_info,
                            "no ColumnInfo named 'file' created" );
    $self->assert_equals( "categorical", $col_info->class() );
    $self->assert_equals( "string", $col_info->type() );
    $self->assert_equals( "A File", $col_info->label() );
    $self->assert_equals( 1, $col_info->col_start() );
    $self->assert_equals( 1, $col_info->col_end() );
    $self->assert_equals( 20, $col_info->col_width() );
    $self->assert_equals( 20, $col_info->max_chars() );
    $self->assert_equals( 8, $col_info->avg_chars() );
}

1;
