package tests::UISelectWidgetTest;

use strict;
no warnings 'redefine';

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;

use Curses::UI;

use Lire::UI::Widget;
use Lire::Test::CursesUIDriver;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );

    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    my $spec = new Lire::Config::ConfigSpec( 'name' => 'lire' );
    my $select = new Lire::Config::SelectSpec( 'name' => 'test' );
    $spec->add( $select );
    foreach my $name ( qw/one two wawa/ ) {
        $select->add( new Lire::Config::OptionSpec( 'name' => $name ) );
    }
    $self->{'select_value'} =
      $spec->get( 'test' )->instance( 'value' => 'two' );
    $self->{'select_undef'} = $spec->get( 'test' )->instance();
    $self->{'spec'} = $spec;

    $self->{'empty_select'} =
        new Lire::Config::SelectSpec( 'name' => 'empty_select' );
    $spec->add( $self->{'empty_select'} );
    return;
}


sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $win = $self->{'window'};
    $self->assert_died( sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::SelectWidget' ) },
                        qr/missing \'value\' parameter/ );
    $self->assert_died( sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::SelectWidget',
                                                      'Value' => {} ) },
                        qr/\'value\' parameter should be a \'Lire::Config::Scalar\' instance, not \'HASH/ );

    my $widget = $win->add( 'test_widget', 'Lire::UI::SelectWidget',
                            'value' => $self->{'select_value'} );
    $self->assert( UNIVERSAL::isa( $widget, 'Lire::UI::SelectWidget' ),
                   "not a Lire::UI::SelectWidget instance: $widget" );

    $self->assert_deep_equals( [ 'one', 'two', 'wawa' ],
                               $widget->{'-values'} );
    $self->assert_num_equals( 1, $widget->{'-selected'} );
    $self->assert_str_equals( \&Lire::UI::SelectWidget::_on_change_cb,
                              $widget->{'-onchange'} );
    $self->assert_str_equals( 'two', $widget->get() );

    $widget = $win->add( 'undef_widget', 'Lire::UI::SelectWidget',
                         'value' => $self->{'select_undef'} );
    $self->assert_null( $widget->{'-selected'}, '-selected should be undef' );

    $widget = $win->add( 'empty_widget', 'Lire::UI::SelectWidget',
                         'value' => $self->{'empty_select'}->instance() );
    $self->assert_deep_equals( [ '-- empty list --' ], $widget->{'-values'} );
    $self->assert_num_equals( 0, $widget->{'-selected'} );
    $self->assert_num_equals( 0, $widget->{'-focusable'} );

    return;
}

sub test_on_change_cb {
    my $self = $_[0];

    my $win = $self->{'window'};

    my $widget = $win->add( 'test_widget', 'Lire::UI::SelectWidget',
                            'value' => $self->{'select_value'} );
    $self->assert_str_equals( 'two', $widget->get() );
    $widget->{'-selected'} = 2;
    Lire::UI::SelectWidget::_on_change_cb( $widget );
    $self->assert_str_equals( 'wawa', $self->{'select_value'}->get() );

    return;
}

1;
