package tests::functional::LrSpec2PotTest;

use strict;

use base qw/Lire::Test::FunctionalTestCase/;
use Lire::Config::Build qw/ac_info/;
use File::Basename qw/dirname/;
use Cwd 'realpath';
use Carp;

sub new {
    my $self = shift->SUPER::new(@_);

    $self->{'testsdir'} = realpath(dirname( __FILE__ ) . "/..");
    $self->{'lr_spec2pot'} = ac_info( 'PERL' ) . ' -w '
      . ' -I ' . $self->{'testsdir'} . "/.. "
      . $self->{'testsdir'} . "/../../script/lr_spec2pot";
    $self->{'schemasdir'} = $self->{'testsdir'} . "/schemas";
    $self->{'reportsdir'} = $self->{'testsdir'} . "/reports";
    $self->{'filtersdir'} = $self->{'testsdir'} . "/filters";
    $self->{'cfgspecdir'} = $self->{'testsdir'} . "/../config-spec";
    $self->{'defaultsdir'} = $self->{'testsdir'} . "/../config-defaults";
    $self->{'filtersdir'} = $self->{'testsdir'} . "/filters";
    $self->{'cfgfile'} = $self->{'testsdir'} . "/data/test.cfg";
    $self->{'potfile'} = $self->{'testsdir'} . "/data/test.pot.pl";
    $self->{'test_cfg_spec'} = $self->{'testsdir'} . "/data/test-cfg_spec.xml";

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_usage {
    my $self = $_[0];

    my $result = $self->lire_run( $self->{'lr_spec2pot'} );
    $self->assert_num_not_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_matches( qr/ missing one or more spec arguments[\w\s]+Usage: /,
                           $result->stderr() );
}

sub test_usage_bad_spec {
    my $self = $_[0];

    my $result = $self->lire_run( "$self->{'lr_spec2pot'} schema:www4 filter:test:bad_id file.txt" );
    $self->assert_num_not_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_matches( qr/Error loading spec 'schema:www4':/,
                           $result->stderr() );
    $self->assert_matches( qr/Error loading spec 'filter:test:bad_id':/,
                           $result->stderr() );
    $self->assert_matches( qr/Error loading spec 'file.txt': specs are strings of the form schema:<id>, filter:<schema>:<id>, report:<schema>:<id>, config_spec:<file> or report_cfg:<schema>:<file>/,
                           $result->stderr() );
}

sub test_lr_spec2pot {
    my $self = $_[0];

    my $cmd = "$self->{'lr_spec2pot'} --cfgspecdir $self->{'cfgspecdir'}" .
      " --defaultsdir $self->{'defaultsdir'}" .
      " --reportsdir $self->{'reportsdir'}" .
      " --filtersdir $self->{'filtersdir'}" .
      " --schemasdir $self->{'schemasdir'}" .
      " report_cfg:test:$self->{'cfgfile'} schema:test schema:test-extended" .
      " report:test:top-dirs report:test:top-files" .
      " filter:test:select-file config_spec:$self->{'test_cfg_spec'} > test.pot.pl";
    my $result = $self->lire_run( $cmd );
    $self->annotate( $result->stderr() );
    $self->assert_num_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_does_not_match( qr/ (crit|err|warning) /, $result->stderr(),
                                  "There were warnings or error messages." );
    open my $e_fh, $self->{'potfile'}
      or die "open $self->{'potfile'} failed: $!";
    open my $g_fh, $self->rundir() . "/test.pot.pl"
      or die "open " . $self->rundir() . "/test.pot.pl failed: $!";
    my $line = 0;
    my ($e_line, $g_line );
    while ( defined(  $e_line = <$e_fh> ) ) {
        $line++;
        my $g_line = <$g_fh>;
        $self->assert_str_equals( "$line: " . $e_line,
                                  "$line: " . $g_line );
    }
    close $e_fh;
    close $g_fh;
}

1;
