package tests::helpers::TestDerivedAnalyzer;

use base qw/Lire::AsciiDlf::DerivedRecordsCreator/;

use Carp;

sub init_computation {
    my ( $self, $dlf_info, $writer_cb ) = @_;

    $self->{'session_cache'}	= {};

    my $base = $self->schema->base;
    $self->{'time_start_idx'} = $base->field( "time_start" )->pos;
    $self->{'time_end_idx'} = $base->field( "time_end" )->pos;
    $self->{'connection_id_idx'} = $base->field( "connection_id" )->pos;

    $self->{'dlf_record_maker'} =
      $self->schema->make_hashref2asciidlf_func( "connection_id", "session_start", "session_end", "session_length" );
}

sub dlf_record {
    my ( $self, $dlf, $writer_cb ) = @_;

    my $id    = $dlf->[$self->{'connection_id_idx'}];
    my $start = $dlf->[$self->{'time_start_idx'}];
    my $end   = $dlf->[$self->{'time_end_idx'}];

    croak "invalid DLF record, transfer ends before it starts: ", join( " ", @$dlf )
      if $end < $start;
    my $rec = $self->{'session_cache'}{$id};
    unless ($rec ) {
        $rec = $self->{'session_cache'}{$id} = { 'connection_id' => $id,
                                               'session_start' => $start,
                                               'session_end'   => $end,
                                               'session_length' => $end - $start,
                                              };
    }

    $rec->{'session_start'} = $start
      if $start < $rec->{'session_start'};

    $rec->{'session_end'} = $end
      if $rec->{'session_end'} < $end;

    $rec->{'session_length'} = $rec->{'session_end'} - $rec->{'session_start'};
    croak "invalid session, length < 0 (start=",
      $rec->{'session_start'}, "; end=", $rec->{'session_end'}, "): ",
        join ( " ", @$dlf )
      if $rec->{'session_length'} < 0;
}

sub end_computation {
    my ( $self, $writer_cb ) = @_;

    foreach my $rec ( values %{$self->{'session_cache'}}) {
        $writer_cb->( $self->{'dlf_record_maker'}->( $rec ) );
    }
    delete $self->{'session_cache'};
}

1;
