<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LRSML/"
  exclude-result-prefixes="lire">

  <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>

  <xsl:param name="specdir" select="'.'"/>
  <xsl:param name="spec-files" select="''"/>

  <!-- Receives the list of XML specification spec-files parameter -->
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="contains($spec-files, ' ')">
	<xsl:call-template name="gen.spec.section">
	  <xsl:with-param name="spec-files" select="normalize-space($spec-files)"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<!-- Only one file was passed and it is probably this
	     stylesheet, since it is included in the dependencies. -->
	<para>None.</para>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="gen.spec.section">
    <xsl:param name="spec-files"/>

    <xsl:choose>
      <xsl:when test="contains($spec-files, ' ')">
	<xsl:variable name="spec-file" 
	  select="concat($specdir, '/', substring-before( $spec-files, ' '))"/>

	<xsl:apply-templates select="document($spec-file)/lire:global-filter-spec"/>
	<xsl:apply-templates select="document($spec-file)/lire:report-spec"/>

	<!-- Recurse -->
	<xsl:call-template name="gen.spec.section">
	  <xsl:with-param name="spec-files" 
	    select="substring-after( $spec-files, ' ' )"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:variable name="spec-file" 
	  select="concat($specdir, '/', $spec-files )"/>
	<!-- Last file -->
	<xsl:apply-templates select="document($spec-file)/global-filter-spec"/>
	<xsl:apply-templates select="document($spec-file)/lire:report-spec"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="lire:report-spec">
    <section id="sect:report.{$superservice}.{@id}">
      <title><xsl:value-of select="lire:title"/></title>

      <!-- Id, chart, desc, params -->
      <segmentedlist>
	<segtitle>ID</segtitle>
	<segtitle>Chart</segtitle>
	<seglistitem>
	  <seg><constant><xsl:value-of select="@id"/></constant></seg>
	  <seg>
	    <xsl:if test="@charttype">
	      <xsl:value-of select="@charttype"/>
	    </xsl:if>
	    <xsl:if test="not(@charttype)">
	      None
	    </xsl:if>
	  </seg>
	</seglistitem>
      </segmentedlist>

      <xsl:apply-templates select="lire:description"/>
      <xsl:apply-templates select="lire:param-spec"/>
      <xsl:if test="not(lire:param-spec)">
	<para>This report doesn't have any parameters.</para>
      </xsl:if>
    </section>
  </xsl:template>

  <xsl:template match="lire:global-filter-spec">
    <section id="sect:filter.{$superservice}.{@id}">
      <title><xsl:value-of select="lire:title"/></title>

      <para>ID: <constant><xsl:value-of select="@id"/></constant></para>

      <xsl:apply-templates select="lire:description"/>
      <xsl:apply-templates select="lire:param-spec"/>
      <xsl:if test="not(lire:param-spec)">
	<para>This filter doesn't have any parameters.</para>
      </xsl:if>
    </section>
  </xsl:template>

  <xsl:template match="lire:description">
    <xsl:copy-of select="*"/>
  </xsl:template>

  <xsl:template match="lire:param-spec">
    <variablelist>
      <title>Parameters</title>
      <xsl:apply-templates select="lire:param"/>
    </variablelist>
  </xsl:template>

  <xsl:template match="lire:param">
    <varlistentry>
      <term><parameter><xsl:value-of select="@name"/></parameter></term>
      <listitem>
	<xsl:apply-templates select="lire:description"/>
	<xsl:if test="@default and string-length(@default)">
	  <para>Defaults to <literal><xsl:value-of
		select="@default"/></literal>.</para>
	</xsl:if>
      </listitem>
    </varlistentry>
  </xsl:template>

</xsl:stylesheet>

<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
