package Lire::Extensions::WWW::AttackSchema;

# vim:syntax=perl

use strict;

use vars qw( $VERSION @ISA );

use Lire::AsciiDlf::ExtendedFieldsCreator;

use Lire::WWW::Filename;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.8 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::AsciiDlf::ExtendedFieldsCreator );
}

sub init_computation {
    my ( $self, $dlf_info ) = @_;

    my $dflt = $self->schema->field( "attack" )->default;
    $self->{'analyzer'} = new Lire::WWW::Filename( 'default' => $dflt );

    # Cache the index of requested_page
    $self->{'filename_idx'} = $self->schema->field( "requested_page" )->pos;
}

sub create_extended_fields {
    my ( $self, $dlf ) = @_;

    my $filename = $dlf->[$self->{'filename_idx'} ];
    if ( ! defined $filename ) {
	return [ undef ];
    } else {
	$self->{'analyzer'}->setFilename($filename);

	return [ $self->{'analyzer'}->getAttack() ];
    }
}

sub end_computation {
    my ( $self ) = shift;

    $self->SUPER::end_computation( @_ );

    # Free memory
    delete $self->{'analyzer'};
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Extension::WWW::AttackSchema -

=head1 SYNOPSIS

 use Lire::Extension::WWW::AttackSchema;

=head1 DESCRIPTION

Interface to the Lire::WWW::Filename package.

=head1 VERSION

$Id: AttackSchema.pm,v 1.8 2003/11/04 17:30:25 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

E.L. Willighagen <egonw@logreport.org>

=cut
