/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/command.h"

class LWCommandInfront: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	g_return_val_if_fail (argc == 0, NULL);

	context->wizard->enableInvertedGrounds (FALSE);
	
	return NULL;
}	

gchar *getName () 
{
	return "infront";
}	

gchar *getHint ()
{
	return _("Be in front");
}

};

LWSymbol *new_LWCommandInfront()
{
	return new LWCommandInfront();
}
