/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/command.h"
#include "include/message.h"

class LWCommandAdd: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 2, NULL);

	gint r = args[0]->toInt() + args[1]->toInt();
	
	return new LWValue (r);
}

const gchar *getName ()
{
	return "add";
}	

gchar *getHint ()
{
	return _("Add");
}

guint getPriority ()
{
	return 12;
}

LWLink getLinkType ()
{
	return LW_LINK_LEFT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgument (guint n, LWValue *value)
{
	(void) n;
	
	if (FALSE == value->isVariable() && FALSE == value->checkRange())
			throw new LWMessage (LW_ERROR_NumberOutOfRange);
}

void checkArgc (guint n)
{
	if (n != 2) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

};

LWSymbol *new_LWCommandAdd()
{
	return new LWCommandAdd();
}
