; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-apple-darwin < %s | FileCheck %s

; This test checks that we don't try to narrow the volatile load by selecting
; the pattern below into a testb instruction.

define void @testb_volatile(i32 **%ptrptr) {
; CHECK-LABEL: testb_volatile:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movq (%rdi), %rax
; CHECK-NEXT:    testl $1, (%rax)
; CHECK-NEXT:    jne LBB0_1
; CHECK-NEXT:  ## %bb.2: ## %exit
; CHECK-NEXT:    movl $1, (%rax)
; CHECK-NEXT:    retq
; CHECK-NEXT:  LBB0_1: ## %bb2
; CHECK-NEXT:    movl $0, (%rax)
; CHECK-NEXT:    retq
entry:
  %ptr = load i32*, i32** %ptrptr, align 8
  %vol_load = load volatile i32, i32* %ptr, align 4
  %and = and i32 %vol_load, 1
  %cmp = icmp eq i32 %and, 0
  br i1 %cmp, label %exit, label %bb2

bb2:
  store i32 0, i32 *%ptr, align 4
  ret void

exit:
  store i32 1, i32 *%ptr, align 4
  ret void
}
