/* =====================================================================

   LiMo - Liblary
      Sync Main System.  - ᥤ롼

                                  Programed by Rero2 (K.Kunikane)

====================================================================== */

/* -------------------------------------------------------------
 --- History

  Nov.28.1999  Programing start (batmon)
  Dec.10.1999  Debug
  Dec.14.1999  Paletteб

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Preface

  RRMainInit          -- ᥤץʤ
  RRMain              -- ֤˥뤵ᥤ
  RRMainFree          -- ᥤץཪλ()
  RRMainWindowSize    -- եå
  RRMainInterval      -- ߻֤
  RRMainIntervalTime  -- ߻֤ɤߤ

  RRMainDragStart     -- ɥĤޤ줿
  RRMainDragEnd       -- ɥΥ줿
  RRMainDragMove      -- ɥư

  monitor_display     -- ̤褹ʬ

-------------------------------------------------------------- */

/* -------------------------------------------------------------
 --- Include
-------------------------------------------------------------- */

#include <stdio.h>
#include <time.h>
#include <gtk/gtk.h>
#include  "rr_main.h"
#include  "rr_screen.h"
#include  "apm_info.h"

/* --- եåǡ */
#include  "../picture/apm_0.xpm"
#include  "../picture/apm_1.xpm"
#include  "../picture/apm_2.xpm"
#include  "../picture/apm_3.xpm"

/* -------------------------------------------------------------
 --- Ƽ
-------------------------------------------------------------- */

#define  INTERVAL   3


/* -------------------------------------------------------------
 --- ؿ
-------------------------------------------------------------- */

void  monitor_display(void);


/* -------------------------------------------------------------
 --- ѿ
-------------------------------------------------------------- */

/* --- ǥץ쥤ݻ */
static gint  fw, fh;

/* --- ߤγ */
static gint  interval;
static gint  int_handle;

/* --- ǡ */
static GdkPixmap  *pic1, *pic2, *pic3, *pic4;
static GdkBitmap  *mask1, *mask2, *mask3;

/* --- Хåƥ꡼֤ɽΥǡ */
static gint  face = -1;
static gint  remain = -1;

/* --- ɥɥåࡼִϢ */
static gboolean win_move;
static gint cur_x, cur_y;

/* -----------------------------------------------------------------------
 --- ץ
------------------------------------------------------------------------ */

/* -------------------------------------------------------------
  RRMainInit       -- ᥤץʤ

   return : void
   void

-------------------------------------------------------------- */
void RRMainInit(void)
{
  int_handle = 0;
  RRScreenFontSetInit("-adobe-times-bold-r-normal-*-16-*-*-*-*-*-*-*,\
            -misc-fixed-medium-*-normal-*-16-*-*-*-*-*-jisx0208.1983-0");

  /* -- ߳ */
  RRMainInterval(INTERVAL);

  /* -- եå pixmap  */
  pic1 = gdk_pixmap_create_from_xpm_d(RRScreenWindow()->window,
				      &mask1,
				      NULL,
				      apm_0_xpm);
  pic2 = gdk_pixmap_create_from_xpm_d(RRScreenWindow()->window,
				      &mask2,
				      NULL,
				      apm_1_xpm);
  pic3 = gdk_pixmap_create_from_xpm_d(RRScreenWindow()->window,
				      &mask3,
				      NULL,
				      apm_2_xpm);
  pic4 = gdk_pixmap_create_from_xpm_d(RRScreenWindow()->window,
				      NULL,
				      NULL,
				      apm_3_xpm);

  ApmInfoGet();
  monitor_display();
  RRScreenSwitch();
}


/* -------------------------------------------------------------
  RRMainFree       -- ᥤץཪλ

   return : void
   void

-------------------------------------------------------------- */
void RRMainFree(void)
{
  if (int_handle != 0) gtk_timeout_remove(int_handle);
  if (pic1 != NULL) gdk_pixmap_unref(pic1);
  if (pic2 != NULL) gdk_pixmap_unref(pic2);
  if (pic3 != NULL) gdk_pixmap_unref(pic3);
  if (pic4 != NULL) gdk_pixmap_unref(pic4);
  if (mask1 != NULL) gdk_bitmap_unref(mask1);
  if (mask2 != NULL) gdk_bitmap_unref(mask2);
  if (mask3 != NULL) gdk_bitmap_unref(mask3);
}


/* -------------------------------------------------------------
  RRMainWindowSize   -- եå

   return : void
   void
-------------------------------------------------------------- */
void       RRMainWindowSize(gint w, gint h)
{
  fw = w;
  fh = h;
}


/* -------------------------------------------------------------
  RRMainInterval   -- ߻֤

   return : void
   gint n(n sec)
-------------------------------------------------------------- */
void RRMainInterval(gint n)
{
  if (int_handle != 0) gtk_timeout_remove(int_handle);
  /* -- ϥ󥿡Х뤬ĹΤ näȤñ̤Ǥ */
  int_handle = gtk_timeout_add(1000*n, (GtkFunction)RRMain, NULL);
  /* --- ͤݻ */
  interval = n;
}


/* -------------------------------------------------------------
  RRMainIntervalTime  -- ߻֤ɤߤ

   return : n (1/n sec)
   void
-------------------------------------------------------------- */
gint RRMainIntervalTime(void)
{
  return(interval);
}


/* -------------------------------------------------------------
  RRMainDragStart     -- ɥĤޤ줿

   return : void
   void
-------------------------------------------------------------- */
void  RRMainDragStart(void)
{
  GdkModifierType modmask;

  win_move = TRUE;
  gdk_window_get_pointer(NULL, &cur_x, &cur_y, &modmask);
}

/* -------------------------------------------------------------
  RRMainDragEnd       -- ɥΥ줿

   return : void
   void
-------------------------------------------------------------- */
void  RRMainDragEnd(void)
{
  GdkModifierType modmask;

  win_move = FALSE;
  gdk_window_get_pointer(NULL, &cur_x, &cur_y, &modmask);
}

/* -------------------------------------------------------------
  RRMainDragMove      -- ɥư

   return : void
   void
-------------------------------------------------------------- */
void  RRMainDragMove(void)
{
  gint  dx, dy, wx, wy;
  GdkModifierType modmask;

  if (win_move == TRUE) {
    dx = cur_x;
    dy = cur_y;
    gdk_window_get_pointer(NULL, &cur_x, &cur_y, &modmask);
    dx -= cur_x;
    dy -= cur_y;
    gdk_window_get_origin((GdkWindow*)RRScreenWindow()->window, &wx, &wy);
    wx -= dx;
    wy -= dy;
    gdk_window_move((GdkWindow*)RRScreenWindow()->window, wx, wy);
  }
}


/* -------------------------------------------------------------
  RRMain           -- ֤˥뤵ᥤ

   return : void
   void
-------------------------------------------------------------- */
gint RRMain(gpointer gdata)
{
  /* --- APM μ */
  ApmInfoGet();
  
  /* --- Graphic Buffer Υå */
  monitor_display();
  RRScreenSwitch();

  return 1;
}



/* -------------------------------------------------------------
  monitor_display     -- ̤褹ʬ

   return : void
   void
-------------------------------------------------------------- */
void monitor_display(void)
{
  RRSprite bar;
  gint battery, h, stat;

  battery = ApmInfoValue();
  stat = ApmInfoStat();

  if (face != stat) {
    face = stat;
    switch(face) {
    case 0:
      RRScreenWinShape(mask1);
      break;
    case 1:
      RRScreenWinShape(mask2);
      break;
    case 2:
      RRScreenWinShape(mask3);
      break;
    }
  }
  switch(face) {
  case 0:
    RRScreenPutPixmap(pic1, 0, 0);
    break;
  case 1:
    RRScreenPutPixmap(pic2, 0, 0);
    break;
  case 2:
    RRScreenPutPixmap(pic3, 0, 0);
    break;
  }

  /* --- Хåƥ꡼ɽ */
  if (face < 2) {
    remain = battery;
    h = battery * 52 / 100;
    bar.sw = TRUE;
    bar.objmap = pic4;
    bar.objmask = NULL;
    bar.x = 4;
    bar.y = 43+52-h;
    bar.w = 31;
    bar.h = h;
    bar.ox = bar.oy = 0;
    bar.offset_x = bar.offset_y = 0;
    RRScreenObjPut(&bar);
  }
}

