/*
 * lmms_main_win.h - declaration of class lmmsMainWin which is the widget for
 *                   the main window of LMMS
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _LMMS_MAIN_WIN_H
#define _LMMS_MAIN_WIN_H

#include "qt3support.h"

#ifdef QT4

#include <QMainWindow>
#include <QWorkspace>
#include <QWhatsThis>

#else

#include <qmainwindow.h>
#include <qworkspace.h>
#include <qwhatsthis.h>

#endif


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "types.h"


class QSplashScreen;
class QToolBar;
class QToolButton;

class songEditor;
class configManager;


class lmmsWorkspace : public QWorkspace
{
public:
	lmmsWorkspace( QWidget * _parent = 0 ) :
		QWorkspace( _parent )
	{
	}
	virtual ~lmmsWorkspace()
	{
	}
	virtual void wheelEvent( QWheelEvent * _e )
	{
		QWorkspace::wheelEvent( _e );
	}
} ;



// TODO: rewrite that crap!!!

class lmmsMainWin : public QMainWindow
{
	Q_OBJECT
public:
	static inline lmmsMainWin * inst( void )
	{
		if( s_instanceOfMe == NULL )
		{
			s_instanceOfMe = new lmmsMainWin();
		}
		return( s_instanceOfMe );
	}
	inline lmmsWorkspace * workspace( void )
	{
		return( m_workspace );
	}
	void FASTCALL resetWindowTitle( const QString & _add = "" );


	static QSplashScreen * s_splashScreen;


public slots:
	inline void emptySlot( void )
	{
	}
	inline void enterWhatsThisMode( void )
	{
		QWhatsThis::enterWhatsThisMode();
	}
	void createNewProject( void );
	void createNewProjectFromTemplate( int _idx );
	void openProject( void );
	bool saveProject( void );
	bool saveProjectAs( void );
	void showSettingsDialog( void );
	void aboutLMMS( void );
	void help( void );
	void toggleBBEditorWin( void );
	void toggleSongEditorWin( void );
	void toggleProjectNotesWin( void );
	void togglePianoRollWin( void );


protected:
	void closeEvent( QCloseEvent * _ce );


private:
	static lmmsMainWin * s_instanceOfMe;

	lmmsWorkspace * m_workspace;

	QToolBar * m_projectTools;
	QToolBar * m_windowTools;

	QToolButton * m_bbEditorWindow;
	QToolButton * m_pianoRollWindow;
	QToolButton * m_projectNotesWindow;
	QToolButton * m_songEditorWindow;
	QToolButton * m_effectBoardWindow;

	QMenu * m_projectMenu;
	QMenu * m_helpMenu;

	QMenu * m_templatesMenu;


	lmmsMainWin();
	~lmmsMainWin();
	lmmsMainWin( const lmmsMainWin & );

	// only main() is allowed to delete an instance of lmmsMainWin
	friend int main( int argc, char * * argv );

	friend class songEditor;
	friend class bbEditor;
	friend class configManager;

} ;

#endif

