/*
 * sound_generator.cpp - base-class for all sound-generator-plugins
 *                       plugins maybe synths, sampler and so on)
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include "sound_generator.h"
#include "channel_track.h"


soundGenerator::soundGenerator( channelTrack * _channel_track ) :
	QWidget( _channel_track->widgetStack() ),
	settings(),
	m_channelTrack( _channel_track )
{
	setFixedSize( 250, 250 );
}



soundGenerator::~soundGenerator()
{
}



void soundGenerator::processAudioBuffer( sampleFrame * _ab, Uint32 _frames,
							notePlayHandle * _n )
{
	m_channelTrack->processAudioBuffer( _ab, _frames, _n );
}



Uint32 soundGenerator::beatLen( notePlayHandle * ) const
{
	return( 0 );
}




#include "sound_generator.moc"

