/*
 * crystal_button.cpp - implementation of crystal-button
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include "qt3support.h"

#ifdef QT4

#include <QPainter>
#include <QMouseEvent>

#else

#include <qpainter.h>

#endif


#include "crystal_button.h"
#include "embed.h"

#include "crystal_button.moc"


crystalButton::crystalButton( const QPixmap & _bg_pm,
				const QPixmap & _icon_pm, QWidget * _parent ) :
	QPushButton( _parent )
{

	m_mouseOver = FALSE;

	m_buttonBg = NULL;
	m_activeButtonBg = NULL;
	m_activeBg = NULL;
	m_inactiveBg = NULL;
	m_hoverBg = NULL;
	m_glass = NULL;
	m_icon = NULL;
	
	setButtonBg( _bg_pm );
	setActiveBg( embed::getIconPixmap( "crystal_bg_green" ) );
	setInactiveBg( embed::getIconPixmap( "crystal_bg_blue" ) );
	setHoverBg( embed::getIconPixmap( "crystal_bg_orange" ) );
	setGlass( embed::getIconPixmap( "crystal_glass" ) );
	setIcon( _icon_pm );

	resize( m_buttonBg->width(), m_buttonBg->height() );

	setCheckable( TRUE );
	setMouseTracking( TRUE );

#ifndef QT4
	//setWFlags (Qt::WNoAutoErase);
	setBackgroundMode( Qt::NoBackground );
#endif
}




crystalButton::~crystalButton()
{
	delete m_buttonBg;
	delete m_activeButtonBg;
	delete m_activeBg;
	delete m_inactiveBg;
	delete m_hoverBg;
	delete m_glass;
	delete m_icon;
}




void crystalButton::paintEvent (QPaintEvent * )
{
#ifdef QT4
	QPainter p( this );
#else
	QPixmap draw_pm( rect().size() );

	QPainter p( &draw_pm, this );
#endif

	if( (
#ifdef QT4
		isChecked()
#else
		isOn()
#endif
		|| isDown()) && m_activeButtonBg != NULL )
	{
		p.drawPixmap( 0, 0, *m_activeButtonBg );
	}
	else
	{
		p.drawPixmap( 0, 0, *m_buttonBg );
	}

	int x_ofs = ( m_buttonBg->width() - m_activeBg->width()) / 2;
	int y_ofs = ( m_buttonBg->height() - m_activeBg->height()) / 2;
	

	if( m_mouseOver == TRUE &&
#ifdef QT4
		isChecked()
#else
		isOn()
#endif
			== FALSE && isDown() == FALSE )
	{
		p.drawPixmap( x_ofs, y_ofs, *m_hoverBg );
		p.drawPixmap( x_ofs, y_ofs, *m_icon );
	}
	else if(
#ifdef QT4
		isChecked()
#else
		isOn()
#endif
			|| isDown() )
	{
		p.drawPixmap( x_ofs, y_ofs, *m_activeBg );
		p.drawPixmap( x_ofs+1, y_ofs+1, *m_icon );
	}
	else
	{
		p.drawPixmap( x_ofs, y_ofs, *m_inactiveBg );
		p.drawPixmap( x_ofs, y_ofs, *m_icon );
	}

	p.drawPixmap( x_ofs, y_ofs, *m_glass );

#ifndef QT4
	// blit all the drawn stuff on the screen...
	bitBlt( this, rect().topLeft(), &draw_pm );
#endif
}




void crystalButton::mouseMoveEvent( QMouseEvent * _me )
{
	int mx = _me->pos().x();
	int my = _me->pos().y();

	if( mx >= 0 && mx < width() && my >= 0 && my < height() )
	{
		if( m_mouseOver == FALSE )
		{
			m_mouseOver = TRUE;
			update();
		}
	}
	else
	{
		if( m_mouseOver == TRUE )
		{
			m_mouseOver = FALSE;
			update();
		}
	}
}




void crystalButton::setButtonBg( const QPixmap & _pm )
{
	delete m_buttonBg;
	
	m_buttonBg = new QPixmap( _pm );
}




void crystalButton::setActiveButtonBg( const QPixmap & _pm )
{
	delete m_activeButtonBg;
	
	m_activeButtonBg = new QPixmap( _pm );
}




void crystalButton::setActiveBg( const QPixmap & _pm )
{
	delete m_activeBg;
	
	m_activeBg = new QPixmap( _pm );
}




void crystalButton::setInactiveBg( const QPixmap & _pm )
{

	delete m_inactiveBg;
	
	m_inactiveBg = new QPixmap( _pm );
}




void crystalButton::setHoverBg( const QPixmap & _pm )
{
	delete m_hoverBg;
	
	m_hoverBg = new QPixmap( _pm );
}




void crystalButton::setGlass( const QPixmap & _pm )
{
	delete m_glass;
	
	m_glass = new QPixmap( _pm );
}




void crystalButton::setIcon( const QPixmap & _pm )
{
	delete m_icon;
	
	m_icon = new QPixmap( _pm );
}
