#include <stdio.h>
#include <libgen.h>
#include <windows.h>
#include <winnt.h>
#include <wine/exception.h>
#include <pthread.h>
#include <signal.h>

/*#include <x11/xlib.h>
#include <x11/xresource.h>
#include <x11/xutil.h>
#include <x11/xatom.h>*/

#include "fstserver.h"


struct ERect{
    short top;
    short left;
    short bottom;
    short right;
};

static pthread_mutex_t plugin_mutex;
static FST * global_fst = NULL;

DWORD  gui_thread_id = 0;


#if 0

/* Define to a macro to generate an assembly function directive */
#define __ASM_FUNC(name) ".type " __ASM_NAME(name) ",@function"

/* Define to a macro to generate an assembly name from a C symbol */
#define __ASM_NAME(name) name

# define __ASM_GLOBAL_FUNC(name,code) \
      __asm__( ".align 4\n\t" \
               ".globl " __ASM_NAME(#name) "\n\t" \
               __ASM_FUNC(#name) "\n" \
               __ASM_NAME(#name) ":\n\t" \
               code );

__ASM_GLOBAL_FUNC( fst_get_teb, ".byte 0x64\n\tmovl 0x18,%eax\n\tret" );

#endif


#define DELAYED_WINDOW

static LRESULT WINAPI 
my_window_proc (HWND w, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_KEYUP:
	case WM_KEYDOWN:
		break;

	case WM_CLOSE:
		/* TODO: inform client about hidden window */
/*		return 0;*/

	case WM_DESTROY:
	case WM_NCDESTROY:
		/* we should never get these */
		break;
	
	case WM_SETFOCUS:
/*		debugMsg( "Got the focus\n" );*/
		break;

	case WM_KILLFOCUS:
/*		debugMsg( "lost focus\n" );*/
		break;

	default:
		break;
	}

	return DefWindowProcA (w, msg, wp, lp );
}

static FST* 
fst_new ()
{
	if( global_fst != NULL )
	{
		return( global_fst );
	}
	global_fst = (FST*) calloc (1, sizeof (FST));

	pthread_mutex_init (&global_fst->lock, NULL);
	pthread_cond_init (&global_fst->window_status_change, NULL);

	return global_fst;
}

static FSTHandle* 
fst_handle_new ()
{
	FSTHandle* fst = (FSTHandle*) calloc (1, sizeof (FSTHandle));
	return fst;
}

#ifdef HAVE_TLS
static __thread int ejmpbuf_valid = FALSE;
static __thread jmp_buf ejmpbuf;
#else
static pthread_key_t ejmpbuf_valid_key;
static pthread_key_t ejmpbuf_key;
#endif




DWORD WINAPI gui_event_loop (LPVOID param)
{
	MSG msg;

	gui_thread_id = GetCurrentThreadId ();
	if (fst_create_editor (global_fst)) {
		fst_error ("cannot create editor for plugin %s\n", global_fst->handle->name);
	}
	pthread_cond_signal (&global_fst->window_status_change);

	if (!global_fst->window) {
		fst_error ("no window created for VST plugin editor\n");
		/*return -1;*/
	}
	else
	{
		/* create idle-timer */
/*		if (!SetTimer (global_fst->window, 1000, 100, NULL)) {
			fst_error ("cannot set timer window");
		}*/
	}


	while (GetMessageA (&msg, NULL, 0,0))
	{
		TranslateMessage( &msg );
		DispatchMessageA (&msg);

		if( global_fst->destroy )
		{
			break;
		}

/*		if( msg.message == WM_TIMER  )
		{
			pthread_mutex_lock (&plugin_mutex);
			global_fst->plugin->dispatcher (global_fst->plugin, effEditIdle, 0, 0, NULL, 0);
			pthread_mutex_unlock (&plugin_mutex);
		}*/

	}
	pthread_cond_signal (&global_fst->window_status_change);
}

void
fst_set_focus (FST* _fst)
{
	if (_fst->window) {
		SetFocus (_fst->window);
	}
}

int
wine_shared_premain ()
{
	WNDCLASSA wc;
	HMODULE hInst;

	if ((hInst = GetModuleHandleA (NULL)) == NULL) {
		fst_error ("can't get module handle");
		return -1;
	}
	wc.style = 0;
	wc.lpfnWndProc = my_window_proc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInst;
	wc.hIcon = LoadIconA( hInst, "FST");
	wc.hCursor = LoadCursorA( NULL, IDI_APPLICATION );
	wc.hbrBackground = GetStockObject( BLACK_BRUSH );
	wc.lpszMenuName = "MENU_FST";
	wc.lpszClassName = "FST";

	if (!RegisterClassA(&wc)){
		return 1;
	}

	return 0;
}

int
fst_run_editor (FST* _fst)
{
	if (CreateThread (NULL, 0, gui_event_loop, NULL, 0, NULL) == NULL) {
		fst_error ("could not create new thread proxy");
		return -1;
	}
	pthread_cond_wait (&_fst->window_status_change, &_fst->lock);

	return 0;
}

int
fst_create_editor (FST* fst)
{
	HMODULE hInst;
	char class[20];
	HWND window;

	/* "guard point" to trap errors that occur during plugin loading */

#ifdef HAVE_TLS
	if (sigsetjmp( ejmpbuf, 1)) {
		fst_error ("creating the editor for %s failed", fst->handle->name);
		return 1;
	}

	ejmpbuf_valid = TRUE;
#else
	jmp_buf* ejmpbuf;
	int* ejmpbuf_valid;

	ejmpbuf = (jmp_buf*) malloc (sizeof (jmp_buf));
	ejmpbuf_valid = (int *) malloc (sizeof (int));
	*ejmpbuf_valid = FALSE;

	pthread_key_create (&ejmpbuf_key, NULL);
	pthread_setspecific (ejmpbuf_key, ejmpbuf);
	pthread_key_create (&ejmpbuf_valid_key, NULL);
	pthread_setspecific (ejmpbuf_valid_key, ejmpbuf_valid);

	if (sigsetjmp (*ejmpbuf, 1)) {
		write (1, "\nDIED\n", 6);
		exit (1);
		return 1;
	}
	
	*ejmpbuf_valid = TRUE;
#endif

	/* Note: fst->lock is held while this function is called */

	if (!(fst->plugin->flags & effFlagsHasEditor)) {
		fst_error ("Plugin \"%s\" has no editor", fst->handle->name);
		return -1;
	}

	if ((hInst = GetModuleHandleA (NULL)) == NULL) {
		fst_error ("can't get module handle");
		return 1;
	}
	
	if ((window = CreateWindowExA (0, "FST", fst->handle->name,
				       (WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME & ~WS_MAXIMIZEBOX),
				       0, 0, 1, 1,
				       NULL, NULL,
				       hInst,
				       NULL)) == NULL) {
		fst_error ("cannot create editor window");
		return 1;
	}

	if (!SetPropA (window, "fst_ptr", fst)) {
		fst_error ("cannot set fst_ptr on window");
	}

	fst->window = window;
	fst->xid = (Sint32) GetPropA (window, "__wine_x11_whole_window");
/*	XChangeWindowAttributes( XOpenDisplay(NULL), fst->xid, CWOverrideRedirect, ~0 ); */


#ifdef DELAYED_WINDOW
	{
		struct ERect* er;
	
		fst->plugin->dispatcher (fst->plugin, effEditOpen, 0, 0, fst->window, 0 );
		fst->plugin->dispatcher (fst->plugin, effEditGetRect, 0, 0, &er, 0 );
		
		fst->width =  er->right-er->left;
		fst->height =  er->bottom-er->top;
		
		SetWindowPos (fst->window, 0, 0, 0, er->right-er->left+8, er->bottom-er->top+26, SWP_SHOWWINDOW|SWP_NOMOVE|SWP_NOZORDER);
		*ejmpbuf_valid = FALSE;

		ShowWindow (fst->window, SW_SHOW);
	}
#else

	pthread_cond_signal (&fst->window_status_change);
	pthread_mutex_unlock (&fst->lock);

#endif 
	return 0;
}

void
fst_show_editor (FST* fst)
{
#ifndef DELAYED_WINDOW
	struct ERect* er;

	fst->plugin->dispatcher (fst->plugin, effEditOpen, 0, 0, fst->window, 0 );
	fst->plugin->dispatcher (fst->plugin, effEditGetRect, 0, 0, &er, 0 );
	fst->width =  er->right-er->left;
	fst->height =  er->bottom-er->top;

	SetWindowPos (fst->window, 0, 0, 0, er->right-er->left+8, er->bottom-er->top+26, SWP_NOMOVE | SWP_NOZORDER);
	*ejmpbuf_valid = FALSE;
	ShowWindow (fst->window, SW_SHOW);
#endif
}
/*
void
fst_hide_editor (FST* fst)
{
	ShowWindow (fst->window, SW_HIDE);

}
*/
void
fst_destroy_editor (FST* fst)
{
	FST* p;
	FST* prev;
	if (fst->window) {
		fst->destroy = TRUE;
		/* make sure, GUI-thread quits */
		if (!PostThreadMessageA (gui_thread_id, WM_USER, 0, 0)) {
			fst_error ("could not post message to gui thread");
		}
		pthread_cond_wait (&fst->window_status_change, &fst->lock);
		if (global_fst->window)
		{
			/* sometimes hangs here, so skip this... */
/*			fst->plugin->dispatcher( fst->plugin, effEditClose, 0, 0, NULL, 0.0 );*/
			CloseWindow (fst->window);
			global_fst->window = NULL;
		}
	}
}


FSTHandle*
fst_load (const char *path)
{
	char* buf, *buf2;
	FSTHandle* fhandle;
	char* period;

	fhandle = fst_handle_new ();
	
	/* XXX: Would be nice to find the correct call for this.
	      if the user does not configure Z: to be / we are doomed :( */

	if (strstr (path, ".dll") == NULL) {

		buf = (char *) malloc (strlen (path) + 7);

		if( path[0] == '/' ) {
		    sprintf (buf, "Z:%s.dll", path);
		} else {
		    sprintf (buf, "%s.dll", path);
		}

		fhandle->nameptr = strdup (path);

	} else {

		buf = (char *) malloc (strlen (path) + 3);

		if( path[0] == '/' ) {
		    sprintf (buf, "Z:%s", path);
		} else {
		    sprintf (buf, "%s", path);
		}

		fhandle->nameptr = strdup (path);
	}
	
	fhandle->name = basename (fhandle->nameptr);

	/* strip off .dll */

	if ((period = strrchr (fhandle->name, '.')) != NULL) {
		*period = '\0';
	}

	if ((fhandle->dll = LoadLibraryA (buf)) == NULL) {
		fst_unload (fhandle);
		return NULL;
	}

	if ((fhandle->main_entry = GetProcAddress (fhandle->dll, "main")) == NULL) {
		fst_unload (fhandle);
		return NULL;
	}

	return fhandle;
}

int
fst_unload (FSTHandle* fhandle)
{
	if (fhandle->plugincnt) {
		return -1;
	}

	if (fhandle->dll) {
		FreeLibrary (fhandle->dll);
		fhandle->dll = NULL;
	}

	if (fhandle->nameptr) {
		free (fhandle->nameptr);
		fhandle->name = NULL;
	}
	
	free (fhandle);
	return 0;
}

FST*
fst_instantiate (FSTHandle* fhandle, audioMasterCallback amc, void* userptr)
{
	FST* fst = fst_new ();

	if( fhandle == NULL ) {
	    fst_error( "the handle was NULL\n" );
	    return NULL;
	}

	if ((fst->plugin = fhandle->main_entry (amc)) == NULL)  {
		fst_error ("%s could not be instantiated\n", fhandle->name);
		free (fst);
		return NULL;
	}
	
	fst->handle = fhandle;
	fst->plugin->user = userptr;
		
	if (fst->plugin->magic != kEffectMagic) {
		fst_error ("%s is not a VST plugin\n", fhandle->name);
		free (fst);
		return NULL;
	}
	
	fst->plugin->dispatcher (fst->plugin, effOpen, 0, 0, 0, 0);
	/*fst->plugin->dispatcher (fst->plugin, effMainsChanged, 0, 0, NULL, 0);*/

	fst->handle->plugincnt++;

	return fst;
}

void
fst_close (FST* fst)
{
	fst_destroy_editor (fst);

/*	fst->plugin->dispatcher (fst->plugin, effMainsChanged, 0, 0, NULL, 0);
	fst->plugin->dispatcher (fst->plugin, effClose, 0, 0, 0, 0);*/

	if (fst->handle->plugincnt) {
		--fst->handle->plugincnt;
	}
}

Sint32
fst_get_XID (FST* fst)
{
	return fst->xid;
}

