/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of Intel Corp. nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifndef _PROTOCOL_H_
#define _PROTOCOL_H_

#include <map>
#include <vector>
#include <string> 
#include "types.h"
#include "LMEConnection.h"
#include "Semaphore.h"
#include "LMS_if.h"

#ifdef _LINUX

#define SOCKET int
#define INVALID_SOCKET  (SOCKET)(~0)
#define SOCKET_ERROR            (-1)

#define QUICK_CONNECT_COUNT 30
#define SLEEP_TIMEOUT 30
#define QUICK_SLEEP_TIMEOUT 5
#endif	// _LINUX

#ifdef _REMOTE_SUPPORT
#include "AdapterListInfo.h"
#endif
typedef void (*EventLogCallback) (void *param, LPTSTR message, WORD eventType);

class Protocol {
public:

	static const unsigned short TCP_PORT = 16992;
	static const unsigned short TLS_PORT = 16993;

	enum SOCKET_STATUS {
		ACTIVE = 0,
		NOT_CREATED,
		LINGER_ERROR,
		NOT_BINDED,
		NOT_EXCLUSIVE_ADDRESS,
		NOT_LISTENED
	};

	Protocol();
	~Protocol();

	bool CreateSockets(SOCKET_STATUS &TCPstatus, SOCKET_STATUS &TLSstatus);
	void DestroySockets();
	bool SocketsCreated() { return _sockets_active; }
	bool IsInitialized() { return _lme.IsInitialized(); }
	bool Init(EventLogCallback cb, void *param);
	int Select();
	void Deinit();
	LMEConnection& GetLMEConnection();

private:
	static void _HECICallback(void *param, UCHAR *buffer, int len, int *status);
#ifdef _REMOTE_SUPPORT
	static void _AdapterCallback(void *param, SuffixMap localDNSSuffixes);
#endif	
	static char *_getErrMsg(DWORD err);

	void _HECIReceive(UCHAR *buffer, int len, int *status);
	SOCKET _createSocket(unsigned long addr, unsigned short port, int type, SOCKET_STATUS &status);
	SOCKET _createServerSocket(unsigned short port, SOCKET_STATUS &status);
	bool _acceptConnection(SOCKET s, unsigned short port);
	bool _setNonBlocking(SOCKET s, bool enable);
	void _closeSocket(SOCKET s, bool lock);
	int _rxFromSocket(SOCKET s);
	int _isLocal(struct sockaddr_in *addr);
	int _handleFQDNChange(const char *fqdn);
	int _updateIPFQDN(LMS_IP_FQDN_MESSAGE *msg);
#ifdef _REMOTE_SUPPORT
	int _isRemoteFromEnterprise(sockaddr_in *addr);
	int _updateDNSSuffixList(LMS_ENTERPRISE_DNS_SUFFIX_LIST_MESSAGE *msg);
	void _updateEnterpriseAccessStatus(const SuffixMap localDNSSuffixes);
#endif
	SOCKET _connect(unsigned long addr, unsigned short port, int type);

	struct Connection {
		SOCKET s;
	};

	typedef map<int, Connection> ConnMap;

	LMEConnection _lme;
	SOCKET _s_tcp;
	SOCKET _s_tls;
	bool _sockets_active;
	ConnMap _openConnections;
	Semaphore _mapLock;
#ifdef _REMOTE_SUPPORT
	vector<string> _AMTDNSSuffixes;
	Semaphore _AMTDNSLock;
	bool _remoteAccessEnabled;
	Semaphore _remoteAccessLock;
#endif
	UINT8 _AMTIPType;
	UINT8 _AMTIPAddress[16];
	UINT8 _AMTFQDN[FQDN_MAX_SIZE];
	EventLogCallback _eventLog;
	void *_eventLogParam;
};

#endif
