#!/usr/bin/perl
# This script configures XFree86 (sarge version 4.3.x)
# The difference of the woody script is in some of the debconf 
# values, otherwise they are similar.

use strict;
use warnings;

my %lang_X_map = (
    # entries sorted alphabetically
    'American (US)'      => { XkbLayout => 'us', XkbModel => 'pc104'},
    'Australian'         => { XkbLayout => 'us', XkbModel => 'pc104' },
    'Belarussian'        => { XkbLayout => 'us,ru', XkbOptions => 'grp:ctrl_shift_toggle,grp_led:scroll', XkbModel => 'pc105', XkbVariant => 'winkeys' },
    'French (BE)'        => { XkbLayout => 'be', XkbModel => 'pc105' },
    'Dutch (BE)'         => { XkbLayout => 'be', XkbModel => 'pc105' },
    'Bosnian'            => { XkbLayout => 'bs', XkbOptions => 'grp:alt_shift_toggle', XkbModel => 'pc105' },
    'Brazilian'          => { XkbLayout => 'br', XkbModel => 'abnt2', XkbVariant => 'abnt2' },
    'Brazilian (latin1)' => { XkbLayout => 'br', XkbModel => 'pc105', XkbVariant => 'us_intl' },
    'British'            => { XkbLayout => 'gb', XkbModel => 'pc105' },
    'Bulgarian'          => { XkbLayout => 'bg', XkbVariant => ',bds', XkbOptions => 'grp:alt_shift_toggle,grp_led:scroll' },
    'Catalan'            => { XkbLayout => 'es', XkbModel => 'pc105' },
    'Canadian'           => { XkbLayout => 'us', XkbModel => 'pc104'},
    'Cornish'            => { XkbLayout => 'gb', XkbModel => 'pc105' },
    'Czech'              => { XkbLayout => 'cz_qwerty', XkbOptions => 'grp:shift_toggle,grp_led:scroll' },
    'Danish'             => { XkbLayout => 'dk', XkbModel => 'pc105' },
    'Dutch'              => { XkbLayout => 'us', XkbModel => 'pc105' },
    'Dutch (NL)'         => { XkbLayout => 'nl', XkbModel => 'pc105' },
    'Dvorak'             => { XkbLayout => 'dvorak', XkbModel => 'pc104' },
    'Estonian'           => { XkbLayout => 'ee', XkbModel => 'pc105' },
    'Faroe'              => { XkbLayout => 'us,fa', XkbOptions => 'grp:ctrl_shift_toggle,grp_led:scroll', XkbModel => 'pc105' },
    'Finnish'            => { XkbLayout => 'fi', XkbModel => 'pc105' },
    'French'             => { XkbLayout => 'fr', XkbModel => 'pc105' },
    'French (CA)'        => { XkbLayout => 'ca', XkbModel => 'pc105' },
    'German (BE)'        => { XkbLayout => 'de', XkbModel => 'pc105' },
    'German'             => { XkbLayout => 'de', XkbModel => 'pc105' },
    'German (ndk)'       => { XkbLayout => 'de', XkbVariant => 'nodeadkeys', XkbModel => 'pc105' },
    'Greek'              => { XkbLayout => 'el', XkbOptions => 'grp:alt_shift_toggle', XkbModel => 'pc105' },
    'Hebrew'             => { XkbLayout => 'il', XkbOptions => 'grp:alt_shift_toggle' },
    'Hungarian'          => { XkbLayout => 'hu', XkbModel => 'pc105' },
    'Icelandic'          => { XkbLayout => 'is', XkbModel => 'pc105' },
    'Irish'              => { XkbLayout => 'gb', XkbModel => 'pc105' },
    'Irish (UK)'         => { XkbLayout => 'gb', XkbModel => 'pc105' },
    'Italian'            => { XkbLayout => 'it', XkbModel => 'pc105' },
    'Japanese'           => { XkbLayout => 'jp', XkbModel => 'jp106' },
    'Korean'             => { XkbLayout => 'us' },
    'Latvian'            => { XkbLayout => 'lv' },
    'Lithuanian'         => { XkbLayout => 'lt', XkbOptions => 'grp:ctrl_shift_toggle', XkbModel => 'pc105' },
    'Macedonian'         => { XkbLayout => 'mk', XkbOptions => 'grp:alt_shift_toggle,grp_led:scroll,grp:lwin_switch,compose:rwin', XkbModel => 'pc104' },
    'Manx Gaelic'        => { XkbLayout => 'gb', XkbModel => 'pc105' },
    'New Norwegian'      => { XkbLayout => 'no', XkbModel => 'pc105' },
    'Norwegian'          => { XkbLayout => 'no', XkbModel => 'pc105' },
    'Polish'             => { XkbLayout => 'pl', XkbModel => 'pc105' },
    'Portuguese'         => { XkbLayout => 'pt', XkbModel => 'pc105' },
    'Punjabi (Gumurkhi)' => { XkbLayout => 'gur', XkbVariant => 'nodeadkeys', XkbModel => 'pc105' },
    'Romanian'           => { XkbLayout => 'ro', XkbModel => 'pc101' },
    'Russian'            => { XkbLayout => 'ru', XkbOptions => 'grp:ctrl_shift_toggle,grp_led:scroll', XkbModel => 'pc105' },
    'Saami'              => { XkbLayout => 'sapmi' },
    'Scots Gaelic'       => { XkbLayout => 'gb', XkbModel => 'pc105' },
    'Serbian'            => { XkbLayout => 'sr', XkbOptions => 'grp_led:num,grp:ctrl_shift_toggle', XkbModel => 'pc105' },
    'Slovakian'          => { XkbLayout => 'sk_qwerty', XkbOptions => 'grp:shift_toggle,grp_led:scroll' },
    'Slovenian'          => { XkbLayout => 'si', XkbOptions => 'grp:alt_shift_toggle', XkbModel => 'pc105' },
    'Spanish (AR)'       => { XkbLayout => 'es' },
    'Spanish'            => { XkbLayout => 'es', XkbModel => 'pc105' },
    'Spanish (MX)'       => { XkbLayout => 'la' },
    'Spanish (PE)'       => { XkbLayout => 'es_la' },
    'Swedish (FI)'       => { XkbLayout => 'fi', XkbModel => 'pc105' },
    'Swedish'            => { XkbLayout => 'se', XkbModel => 'pc105' },
    'Swiss (DE)'         => { XkbLayout => 'ch', XkbVariant => 'de', XkbModel => 'pc105' },
    'Swiss (FR)'         => { XkbLayout => 'ch', XkbVariant => 'fr', XkbModel => 'pc105' }, 
    'Tagalog'            => { XkbLayout => 'us', XkbModel => 'pc105' },
    'Turkish (Q layout)' => { XkbLayout => 'tr', XkbOptions => 'caps:shift', XkbModel => 'pc105' },
    'Turkish (F layout)' => { XkbLayout => 'tr', XkbVariant => 'tr_f', XkbOptions => 'caps:shift', XkbModel => 'pc105' },
    'Ukrainian'          => { XkbLayout => 'ua', XkbOptions => 'grp_led:num,grp:ctrl_shift_toggle', XkbModel => 'pc105' },
);

sub get_lang_X_map() {
    return %lang_X_map;
}

1;
