<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:output doctype-system="lodju.dtd" indent="yes"/>

  <xsl:template match="lodju-archive">
    <lodju-document>
    	<xsl:call-template name="generate-id"/>
    	<folders>
	    <xsl:apply-templates select="folder"/>
	</folders>
    </lodju-document>
  </xsl:template>
  
  <xsl:template match="title">
    <attribute>
      <name>name</name>
      <value><xsl:value-of select="."/></value>
    </attribute>
  </xsl:template>

  <xsl:template match="date-created | creator | privacy">
  </xsl:template>

  <xsl:template match="attribute">
    <attribute>
      <name><xsl:value-of select="@name"/></name>
      <value><xsl:value-of select="."/></value>
    </attribute>
  </xsl:template>

  <xsl:template match="folder">
    <folder>
      <xsl:call-template name="generate-id"/>
      <xsl:apply-templates select="name | title | attribute"/>
      <photos>
	<xsl:apply-templates select="image"/>
      </photos>
      <folders>
	<xsl:apply-templates select="folder"/>
      </folders>
    </folder>
  </xsl:template>

  <xsl:template match="name">
    <attribute>
      <name>name</name>
      <value><xsl:value-of select="."/></value>
    </attribute>
  </xsl:template>

  <xsl:template match="image">
    <photo>
      <xsl:call-template name="generate-id"/>
      <xsl:apply-templates/>
    </photo>
  </xsl:template>
  
  <xsl:template match="filespec">
    <attribute>
      <name>imported-from</name>
      <value><xsl:value-of select="@uri"/></value>
    </attribute>
  </xsl:template>

  <xsl:template match="rotation">
    <attribute>
      <name>rotation</name>
      <value><xsl:value-of select="."/></value>
    </attribute>
  </xsl:template>
  
  <xsl:template name="generate-id">
    <attribute>
      <name>id</name>
      <value><xsl:number level="any" from="/"
      	       	         count="lodju-document | folders | folder | photos | photo"/></value>
    </attribute>
  </xsl:template>

</xsl:stylesheet>
