# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.

# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""tests for the astng utils module

Copyright (c) 2003-2005 LOGILAB S.A. (Paris, FRANCE).
http://www.logilab.fr/ -- mailto:contact@logilab.fr
"""

__revision__ = "$Id: unittest_astng_utils.py,v 1.1 2005/04/25 14:47:05 syt Exp $"

import unittest

from logilab.common.astng import builder, ASTNGManager

from logilab.common.astng import utils


abuilder = builder.ASTNGBuilder(ASTNGManager()) 
MODULE2 = abuilder.file_build('data/module2.py', 'data.module2')

class UtilsTC(unittest.TestCase):
    
    def test_is_metaclass(self):
        klass = MODULE2.locals['Metaclass']
        self.assert_(utils.is_metaclass(klass))
        klass = MODULE2.locals['MyException']
        self.assert_(not utils.is_metaclass(klass))
        
    def test_is_interface(self):
        klass = MODULE2.locals['MyIFace']
        self.assert_(utils.is_interface(klass))
        klass = MODULE2.locals['MyException']
        self.assert_(not utils.is_interface(klass))
        
    def test_is_exception(self):
        klass = MODULE2.locals['MyException']
        self.assert_(utils.is_exception(klass))
        klass = MODULE2.locals['MyError']
        self.assert_(utils.is_exception(klass))
        klass = MODULE2.locals['MyIFace']
        self.assert_(not utils.is_exception(klass))
        
    def test_is_abstract(self):
        method = MODULE2.locals['AbstractClass'].locals['to_override']
        self.assert_(utils.is_abstract(method, pass_is_abstract=False))
        klass = MODULE2.locals['AbstractClass'].locals['return_something']
        self.assert_(not utils.is_abstract(klass, pass_is_abstract=False))
        # non regression : test raise "string" doesn't cause an exception in is_abstract
        func = MODULE2.locals['raise_string']
        self.assert_(not utils.is_abstract(func, pass_is_abstract=False))
        
    def test_get_interfaces(self):
        for klass, interfaces in (('Concrete0', ['MyIFace']),
                                  ('Concrete1', ['MyIFace', 'AnotherIFace']),
                                  ('Concrete2', ['MyIFace', 'AnotherIFace']),
                                  ('Concrete23', ['MyIFace', 'AnotherIFace'])):
            klass = MODULE2.locals[klass]
            self.assertEquals([i.name for i in utils.get_interfaces(klass)],
                              interfaces)
        
    def test_get_raises(self):
        method = MODULE2.locals['AbstractClass'].locals['to_override']
        self.assertEquals([str(term) for term in utils.get_raises(method)],
                          ["CallFunc(Name('NotImplementedError'), [], None, None)"] )
        
    def test_get_returns(self):
        method = MODULE2.locals['AbstractClass'].locals['return_something']
        # use string comp since Node doesn't handle __cmp__ 
        self.assertEquals([str(term) for term in utils.get_returns(method)],
                          ["Const('toto')", "Const(None)"])

__all__ = ('UtilsTC',)

if __name__ == '__main__':
    unittest.main()
