
/*
    Copyright (c) 2008 Andrew Caudwell (acaudwell@gmail.com)
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. The name of the author may not be used to endorse or promote products
       derived from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef FONTPACK_H
#define FONTPACK_H

#include "display.h"
#include "sdlapp.h"
#include "texture.h"

#include <map>
#include <string>

class FPChar {
public:
    int id;
	int font_size;
    int base;
    int w;
    int h;
    vec2f tmin;
    vec2f tmax;
	FPChar();
	FPChar(const char* line, TextureResource* tex);
	void draw(vec2f pos);
};

class FPSize {
    FPChar chars[256];
    TextureResource* texture;

    int space;

    vec3f charColour(int c);

public:
    FPSize(int size, TextureResource* texture);

    int size;

	int render(int x, int y, const char *text, bool force_colour = false, bool test = false);
    void setChar(int charid, FPChar fpchar);
};

class FontPack;

class FPInstance {

    //shadow controls
    bool  shadow;
    float sstrength;
    vec2f soffset;

    FontPack* fp;
    FPSize* font;
public:
    FPInstance();
    FPInstance(FontPack* fp, int size, bool shadow = false);

    void setSize(int size);
    int getSize();

    int print(int x, int y, const char *str, ...);
    int draw(int x, int y, const char* text);

    int width(const char *text);

    void dropShadow(bool shadow);
    void shadowStrength(float s);
    void shadowOffset(float x, float y);

};

class FontPack {
    std::map<int, FPSize*> fsize;
    TextureResource* texture;

public:
    FontPack(std::string tgafile, std::string infofile);
    ~FontPack();

    FPSize* getFontSize(int size);

    TextureResource* getTexture();

    FPInstance getInstance();
    FPInstance getInstance(int size, bool shadow=false);

};


#endif
