/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"


void lt_setup(int argc, char **argv) {
	/* Get the cmdline options and set up the environment accordingly */
	lt_getopts(argc, argv);
	/* Initialize the regex stuff's */
	lt_regexinit();
	
	/* Set up the colors for whatever output mode we're in (if needed) */
	switch(cf.outfmt) {
		case OUTPUT_ANSI:
			lt_colorset_ansi();
			break;
		case OUTPUT_CSV:
			lt_colorset_csv();
			break;
		case OUTPUT_HTML:
			printf("<TABLE bgcolor=black><TR><TD>\n\n");
			lt_colorset_html();
			break;
	}
		
}

void lt_run() {
	/* feed ourselves into the main loop				*/
	lt_loop();

	/* note: we do this from the lt_run wrapper function since we 
	 * kind of expect that someday we'll have more to lt_run than
	 * just calling the main loop :)
	 */
}

void lt_cleanup() {

	switch(cf.outfmt) {
		case OUTPUT_ANSI:
			if(cf.input == TRUE)
				printf("\n");
			break;	
		case OUTPUT_ASCII:
			if(cf.input == TRUE) 
				printf("\n");
			break;
		case OUTPUT_HTML: /* we don't care to check if we did anything in HTML format - we draw the table anyway */
			printf("\n</TABLE></PRE>\n");
			break;
		default:
			break;
	}
	
	/* Ain't no cleanup to do at the moment.  If we ever need to 	*/
	/* though, we can just put it here and be done with it		*/
}
