#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm.pm,v 1.6 2001/11/02 13:55:42 lsimonneau Exp $
##*****************************************************************************
##  ComplexAlarm 
##  Description  : Implement a complex alarm
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: ComplexAlarm.pm,v $
#Revision 1.6  2001/11/02 13:55:42  lsimonneau
#Add Action support for agents' alarms.
#Add action support for LinuxAgent Process alarms.
#
#Revision 1.5  2001/10/31 16:43:35  lsimonneau
#Move Action to LogTrend root.
#
#Revision 1.4  2001/10/01 09:11:59  lsimonneau
#Rename xmessageAction.pm into XmessageAction.pm
#--------------------------------------------
#
#Revision 1.3  2001/07/25 12:56:10  lsimonneau
#Minor bugfixes.
#
#Revision 1.2  2001/07/25 12:07:49  lsimonneau
#Moved module files to the right directories
#Updated package names and uses to reflect those changes
#
#Revision 1.3  2001/06/29 11:55:01  lsimonneau
#Amlioration des message d'erreur, Die -> die.
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm;

use strict;
use LogTrend::ComplexAlarm::Equation;
use XML::DOM;
use LogTrend::ComplexAlarm::DataBase::ComplexAlarmPostgreSQLDataBase;
use LogTrend::Action::ActionSet;

##*****************************************************************************
## Constructor  public
##  Description  : creat a new ComplexAlarm
##  Parameters   : the XML file name 
##*****************************************************************************
sub new {
    my ($classname, $filename) = @_;
    my $self = {};

    bless($self, $classname);
    
    $self->{FILENAME} = $filename;
    
    $self->ParseXMLConfigFile();
    
    return $self;
}


##*****************************************************************************
## Method ParseXMLConfigFile  private
##  Description  : Parse the XML config file and create Action and Equation
##                 objects
##  Parameters   : the XML file name 
##*****************************************************************************
sub ParseXMLConfigFile {
    my ($self) = @_;
    my ($list,$node,$valueref,$attributes,$attrnode);

    # Create a new XML::DOM parser and parse the config file
    my $parser = new XML::DOM::Parser() or die($!);
    my $doc = $parser->parsefile( $self->{FILENAME} ) or die("$self->{FILENAME}: $!");
        
    # Scan the DOM tree
    my $rootlist = $doc->getElementsByTagName("ComplexAlarm") 
	or die("$self->{FILENAME}: No \"ComplexAlarm\" tag.");
    
    ## Tag ComplexAlarm
    my $rootnode = $rootlist->item(0) 
	or die("$self->{FILENAME}: No \"ComplexAlarm\" tag.");
    

    ## Tag DataBase
    $list = $rootnode->getElementsByTagName("DataBase")
	or die("$self->{FILENAME}: No \"DataBase\" tag.");
    
    $node = $list->item(0) or die("$self->{FILENAME}: No \"DataBase\" tag.");
    $attributes = $node->getAttributes() || die("$self->{FILENAME}: Error in \"DataBase\" tag.");

    ## Attributes of Database
    my $attrname;
    foreach $attrname ("Name", "Host", "Port", "User", "Password") {
	$attrnode = $attributes->getNamedItem($attrname) ||
	    die("$self->{FILENAME}: No '$attrname' field in \"DataBase\" tag.");
	$self->{"DB".uc($attrname)} = $attrnode->getValue();
    }

    ## Tag Name, Source, Agent and Number        
    my $nodename;
    foreach $nodename ("Name", "Source", "Agent", "Number") {
	$list = $rootnode->getElementsByTagName($nodename)
	    or die("$self->{FILENAME}: No \"$nodename\" tag.");
    
	$node = $list->item(0) or die("$self->{FILENAME}: No \"$nodename\" tag.");
	$valueref = $node->getFirstChild() or die("$self->{FILENAME}: No \"$nodename\"  tag.");

	$self->{uc($nodename)} = $valueref->getNodeValue();    
    }
    
    ## Tag Level
    $list = $rootnode->getElementsByTagName("Level")
	or die("$self->{FILENAME}: No \"Level\" tag.");
    
    $node = $list->item(0) or die("$self->{FILENAME}: No \"Level\" tag.");
    
    $list = $node->getChildNodes();

    $node = $list->item(0) or die("$self->{FILENAME}: No \"Level\" tag.");
    
    my $level_name = $node->getNextSibling()->getNodeName();
    $level_name =~ /^(Warning)|(Error)|(Info)$/ 
	or die("$self->{FILENAME}: \"$level_name\" is not a valid Level.");
    
    $self->{LEVEL} = $level_name;
    

    ## Tag Action
    $self->{ACTIONSET} = new LogTrend::Action::ActionSet($rootnode);


    ## Tag Equation
    $list = $rootnode->getElementsByTagName("Equation")
	or die("$self->{FILENAME}: No \"Equation\" tag.");
    
    $node = $list->item(0) or die("$self->{FILENAME}: No \"Equation\" tag.");
    $valueref = $node->getFirstChild() or die("$self->{FILENAME}: No \"Equation\"  tag.");

    $self->{EQUATION_STRING} = $valueref->getNodeValue();
    
    $self->{DATABASE} = LogTrend::ComplexAlarm::DataBase::ComplexAlarmPostgreSQLDataBase->new($self->{DBNAME},
											      $self->{DBHOST},
											      $self->{DBPORT},
											      $self->{DBUSER},
											      $self->{DBPASSWORD});
}

##*****************************************************************************
## Run method  public
##  Description  : Check the equation and run actions
##  Parameters   : 
##*****************************************************************************
sub Run
{
    my $self = shift;
    
    $self->{EQUATION} = LogTrend::ComplexAlarm::Equation->new($self->{EQUATION_STRING},
							      $self->{SOURCE},
							      $self->{AGENT},
							      $self->{NUMBER},
							      $self->{DATABASE});

    if($self->{EQUATION}->Run()){
	$self->{ACTIONSET}->Run($self->{LEVEL});
	# 	warn "ALARM !!!!!\n";
    }
}


##*****************************************************************************
## Register method  public
##  Description  : Add a new complex alarm description in the database
##  Parameters   : 
##*****************************************************************************
sub Register
{
    my $self = shift;
    
    $self->{DATABASE}->StoreComplexAlarmDescription($self->{SOURCE},
						    $self->{AGENT}, 
						    $self->{NUMBER},
						    $self->{NAME}, 
						    $self->{LEVEL});

}

1;
