#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Equation.pm,v 1.2 2001/07/25 12:00:47 lsimonneau Exp $
##*****************************************************************************
##  Class Equation 
##  Description  : Parse and execute an equation. 
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: Equation.pm,v $
#Revision 1.2  2001/07/25 12:00:47  lsimonneau
#Ajout du support des equations arithmtiques sur les variables en argument des fonctions de detection.
#
#Revision 1.1  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm::Equation;

use strict;
use LogTrend::ComplexAlarm::Equation::PropertiesParser;
use LogTrend::ComplexAlarm::Equation::FunctionParser;
use LogTrend::ComplexAlarm::DataBase::ComplexAlarmDataBase;

##*****************************************************************************
## Constructor  public
##  Description  : creat a new Equation
##  Parameters   : the equation string,
##                 the source name,
##                 the agent name,
##                 the complex alarm nunmber 
##                 and a DataBaseInterface object.
##*****************************************************************************
sub new {
    my ($classname, $equation, $source, $agent, $number, $database) = @_;
    my $self;
    
    $self->{SOURCE} = $source;
    $self->{AGENT} = $agent;
    $self->{NUMBER} = $number;
    $self->{DATABASE} = $database;
    $self->{EQUATION} = $equation;
    $self->{PROP_PARSER} = LogTrend::ComplexAlarm::Equation::PropertiesParser->new($equation);
    $self->{FUNC_PARSER} = LogTrend::ComplexAlarm::Equation::FunctionParser->new($equation);

    bless($self, $classname);
    
    return $self;
}

##*****************************************************************************
## Run method  public
##  Description  : Run equation parsers
##  Parameters   : 
##  Return       : True if the equation is verified, false otherwise
##*****************************************************************************
sub Run
{
    my $self = shift;
    my @returned_value;
    my @varlist;
    my $datetime_cond;
    my $var_values_hash_ref;
    my $var_types_hash_ref;
    my $function_result;
    
    # Run the properties parser 
    ($datetime_cond, @varlist) = @{$self->{PROP_PARSER}->Run()};
            
    @varlist = split(':', join(':', @varlist));

    # retrieve a reference on the variable initial values table
    ($var_values_hash_ref, $var_types_hash_ref)=$self->{DATABASE}->GetDataValues($self->{SOURCE}, $self->{AGENT}, $self->{NUMBER}, $datetime_cond, \@varlist);

    # Run the function parser
    $function_result = $self->{FUNC_PARSER}->Run($var_values_hash_ref, $var_types_hash_ref);

    my @keylist;
    my $var_name;

    @keylist = keys %$function_result;

    foreach $var_name (@keylist){
	if(defined @{$function_result->{$var_name}}) {
	    $self->{DATABASE}->StoreComplexAlarm($self->{SOURCE}, $self->{AGENT}, $self->{NUMBER});
	    return 1;
	}
    }

    return 0;
}

1;
