#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Equation/FunctionParser.pm,v 1.6 2001/09/26 15:44:53 lsimonneau Exp $
##*****************************************************************************
## Class FunctionParser 
##  Description  : The equation parser for fonctions properties collection 
##                 (see EquationParser.pm)
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: FunctionParser.pm,v $
#Revision 1.6  2001/09/26 15:44:53  lsimonneau
#Reimplementation of the Equation parser.
#
#Revision 1.5  2001/08/24 15:51:10  lsimonneau
#Adapt arithmetics calculs to Consolidated database.
#
#Revision 1.4  2001/07/25 12:00:47  lsimonneau
#Ajout du support des equations arithmtiques sur les variables en argument des fonctions de detection.
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm::Equation::FunctionParser;

use strict;
use LogTrend::ComplexAlarm::Equation::EquationParser;
use LogTrend::ComplexAlarm::Function::FunctionLoader;

@LogTrend::ComplexAlarm::Equation::FunctionParser::ISA = ("LogTrend::ComplexAlarm::Equation::EquationParser");

##*****************************************************************************
## Constructor  public
##  Description  : creat a new FunctionParser
##  Parameters   : the equation string
##*****************************************************************************
sub new
{
    my ($classname, $equation) = @_;
    my $self = $classname->SUPER::new($equation);
        
    bless($self, $classname);

    $self->{PSEUDO_VAR_NBR} = 0;

    return $self;
}



##*****************************************************************************
## Method Run public
##  Description  : parse the equation and call he following protected methods.
##  Parameters   : none
##*****************************************************************************
sub Run
{
    my ($self, $variable_values_hash_ref, $variable_types_hash_ref) = @_;
    
    $self->{VAR_INIT_VAL} = $variable_values_hash_ref;
    $self->{VAR_TYPES} = $variable_types_hash_ref;
        
    return $self->SUPER::Run();
}


##*****************************************************************************
## Method FUNCTION virtual protected
##  Description  : Called by the parser when a function is parsed.
##  Parameters   : The function name
##                 The list of arguments name.
##*****************************************************************************
sub FUNCTION
{
    my ($self, $funcname, @arglist) = @_;
    my $returned_var_hash;
    my $cur_res_ref = $self->{CUR_RES_REF};

    # Launch the Run method of the function and retrieve a reference on a hash
    $returned_var_hash=eval("LogTrend::ComplexAlarm::Function::${funcname}".'::Run($self->{VAR_INIT_VAL}, $self->{VAR_TYPES}, $cur_res_ref, @arglist)');

    $self->{CUR_RES_REF} = $returned_var_hash;
   return $returned_var_hash;
}

##*****************************************************************************
## Method APPLY_AND virtual protected
##  Description  : Called by the parser when an AND operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_AND
{    
    my ($self, $left_comp, $right_comp) = @_;
    my @var_list = keys %{$self->{VAR_INIT_VAL}};
    my $var_name;
    my %result;
    my ($index1, $index2, $index3);
    my ($left_comp_list, $right_comp_list);

    foreach $var_name (@var_list) {
	my @list_res;
	
	# if the variable is not used in the two results, does nothing
	if(!(defined $left_comp->{$var_name}) and 
	   !(defined $right_comp->{$var_name})) {
	    next;
	}
	# if the variable is used by only one result, just copy this result
	elsif(!(defined $left_comp->{$var_name}) and 
	      (defined $right_comp->{$var_name})) {
	    $result{$var_name} = $right_comp->{$var_name};
	}   
	elsif((defined $left_comp->{$var_name}) and 
	      !(defined $right_comp->{$var_name})) {
	    $result{$var_name} = $left_comp->{$var_name};
	}
	# if the variable is used by both left and right results, do a logical AND between the two array
	else {
	    $left_comp_list = $left_comp->{$var_name};
	    $right_comp_list = $right_comp->{$var_name};
	    
	    $index1 = $index2 = $index3 = 0;
	    while(defined $right_comp_list->[$index1] and
		  defined $left_comp_list->[$index2]) {
		# if dates are equal, save this data
		if($right_comp_list->[$index1][1] == $left_comp_list->[$index2][1]){
		    $list_res[$index3++] = $right_comp_list->[$index1++];
		    $index2++;
		}
		# else continue
		elsif($right_comp_list->[$index1][1] < $left_comp_list->[$index2][1]) {
		    $index1++;
		}
		else {
		    $index2++;
		}
	    }
	    	    
	    $result{$var_name} = \@list_res;
	}
    }

    $self->{CUR_RES_REF} = \%result;
    return \%result;
}

##*****************************************************************************
## Method APPLY_OR virtual protected
##  Description  : Called by the parser when an OR operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_OR
{
    my ($self, $left_comp, $right_comp) = @_;
    my @var_list = keys %{$self->{VAR_INIT_VAL}};
    my $var_name;
    my %result;
    my ($index1, $index2, $index3);
    my ($left_comp_list, $right_comp_list);

    foreach $var_name (@var_list) {
	my @list_res;

	# if the variable is not used in the two results, does nothing
	if(!(defined $left_comp->{$var_name}) and 
	   !(defined $right_comp->{$var_name})) {
	    next;
	}
	# if the variable is used by only one result, just copy this result
	elsif(!(defined $left_comp->{$var_name}) and 
	      (defined $right_comp->{$var_name})) {
	    $result{$var_name} = $right_comp->{$var_name};
	}   
	elsif((defined $left_comp->{$var_name}) and 
	      !(defined $right_comp->{$var_name})) {
	    $result{$var_name} = $left_comp->{$var_name};
	}
	# if the variable is used by both left and right results, do a logical OR between the two array
	else {
	    $left_comp_list = $left_comp->{$var_name};
	    $right_comp_list = $right_comp->{$var_name};

	    $index1 = $index2 = $index3 = 0;
	    while(defined $right_comp_list->[$index1] or
		  defined $left_comp_list->[$index2]) {
		# if there are no more data in the right result, just copy the left component
		if(!defined $right_comp_list->[$index1]){
		    $list_res[$index3++] = $left_comp_list->[$index2++];
		}
		# if there are no more data in the left result, just copy the right component
		elsif(!defined $left_comp_list->[$index2]){
		    $list_res[$index3++] = $right_comp_list->[$index1++];
		}
		else {
		    # if the two results have the same date, copy just one of them
		    if($right_comp_list->[$index1][1] == $left_comp_list->[$index2][1]){
			$list_res[$index3++] = $right_comp_list->[$index1++];
			$index2++;
		    }
		    # if the right has a lower date, add the right
		    elsif($right_comp_list->[$index1][1] < $left_comp_list->[$index2][1]) {
			$list_res[$index3++] = $right_comp_list->[$index1++];
		    }
		    # if the left has a lower date, add the left
		    else {
			$list_res[$index3++] = $left_comp_list->[$index2++];
		    }
		}
	    }
	    
	    $result{$var_name} = \@list_res;
	}
    }

    $self->{CUR_RES_REF} = \%result;
    return \%result;
}

##*****************************************************************************
## Method APPLY_NOT virtual protected
##  Description  : Called by the parser when an NOT operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_NOT
{
    my ($self, $right_comp) = @_;
    my @var_list = keys %$right_comp;
    my $list_init;
    my $var_name;
    my %result;
    my ($index1, $index2, $index3);
    my $right_comp_list;

    foreach $var_name (@var_list) {
	my @list_res;    
	$list_init = $self->{VAR_INIT_VAL}->{$var_name};

	$right_comp_list = $right_comp->{$var_name};

	$index1 = $index2 = $index3 = 0;
	
	while(defined $right_comp_list->[$index1]) {
	    while($right_comp_list->[$index1][1] != $list_init->[$index2][1]) {
		$list_res[$index3] = $list_init->[$index2];
		$index2++;
		$index3++;
	    }

	    while(defined $right_comp_list->[$index1] and
		  $right_comp_list->[$index1][1] == $list_init->[$index2][1]) {
		$index1++;
		$index2++;
	    }
	}
	
	while(defined $list_init->[$index2]){
	    $list_res[$index3] = $list_init->[$index2];
	    $index2++;
	    $index3++;	    
	}
	
	$result{$var_name} = \@list_res;
    }

    $self->{CUR_RES_REF} = \%result;
    return \%result;
}


##*****************************************************************************
## Method APPLY_PLUS virtual protected
##  Description  : Called by the parser when an + arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_PLUS
{
    my ($self, $left_op, $right_op) = @_;

    $self->arithm_calc($left_op, $right_op, '+');
    
    return $self->{CUR_PSEUDO_VAR};
}

##*****************************************************************************
## Method APPLY_MINUS virtual protected
##  Description  : Called by the parser when an - arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_MINUS
{
    my ($self, $left_op, $right_op) = @_;
    
    $self->arithm_calc($left_op, $right_op, '-');
    
    return $self->{CUR_PSEUDO_VAR};
}


##*****************************************************************************
## Method APPLY_MULT virtual protected
##  Description  : Called by the parser when an * arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_MULT
{
    my ($self, $left_op, $right_op) = @_;
    
    $self->arithm_calc($left_op, $right_op, '*');

    return $self->{CUR_PSEUDO_VAR};
}


##*****************************************************************************
## Method APPLY_DIV virtual protected
##  Description  : Called by the parser when an / arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_DIV
{
    my ($self, $left_op, $right_op) = @_;
    
    $self->arithm_calc($left_op, $right_op, '/');

    return $self->{CUR_PSEUDO_VAR};
}

##*****************************************************************************
## Method arithm_calc private
##  Description  : 
##  Parameters   : none
##*****************************************************************************
sub arithm_calc
{
    my ($self, $left_op, $right_op, $operator) = @_;

    if($left_op =~ /^\d+(\.\d+)?$/ and $right_op =~ /^\d+(\.\d+)?$/) {
	return eval("$left_op $operator $right_op");
    }
    elsif($left_op =~ /^\d+(\.\d+)?$/) {
	return $self->arithm_calc_num_var($left_op, $right_op, $operator);
    }
    elsif($right_op =~ /^\d+(\.\d+)?$/) {
	return $self->arithm_calc_var_num($left_op, $right_op, $operator);
    }

    $self->{CUR_PSEUDO_VAR} = "_pseudovar".$self->{PSEUDO_VAR_NBR};
    $self->{PSEUDO_VAR_NBR}++;

    $self->{VAR_INIT_VAL}->{$self->{CUR_PSEUDO_VAR}} = ();
    $self->{VAR_TYPES}->{$self->{CUR_PSEUDO_VAR}} = "real";

    ## Data frequency of right operand
    my $right_data = $self->{VAR_INIT_VAL}->{$right_op};
 
    return if $#$right_data == -1;

    my $index = 1;
    my $sum = 0;

    while(defined $right_data->[$index] and $index <= 10){
	$sum += $right_data->[$index][1] - $right_data->[$index-1][1];
	$index++;       	
    }

    ## 
    my $freq = $sum/($index-1);
    $index = 0;
    my $index2 = 0;

    foreach my $data (@{$self->{VAR_INIT_VAL}->{$left_op}}) {
	if($index <= 10) {
	    $index2 = $index;
	}
	else {
	    $index2 = 11 if $index2 < 11;
	    while($index2 < $index) {
		$sum += ($right_data->[$index2][1] - $right_data->[$index2-1][1]);
		$sum -= ($right_data->[$index2 - 10][1] - $right_data->[$index2 - 11][1]) ;
		$freq = $sum/10;
		$index2++;
	    }
	}
		
	# search the better date in right operand data
	while(defined $right_data->[$index+1] and
	      $right_data->[$index][1] < $data->[1] - $freq) {
	    $index++;
	}

	my $date_diff = abs($data->[1] - $right_data->[$index][1]);
	while(defined $right_data->[$index+1] and
	      abs($data->[1] - $right_data->[$index+1][1]) < $date_diff) {
	    $index++;
	    $date_diff = abs($data->[1] - $right_data->[$index][1]);
	}

	if($right_data->[$index][1] > ($data->[1] + $freq) or
	   $right_data->[$index][1] < ($data->[1] - $freq)) {
	    next;
	}
	
	my $res = eval '$data->[0]'." $operator ".'$right_data->[$index][0]';

	push @{$self->{VAR_INIT_VAL}->{$self->{CUR_PSEUDO_VAR}}}, [$res, int(($data->[1] + $right_data->[$index][1])/2)];
    }
}



sub arithm_calc_num_var {
    my ($self, $left_op, $right_op, $operator) = @_;

    $self->{CUR_PSEUDO_VAR} = "_pseudovar".$self->{PSEUDO_VAR_NBR};
    $self->{PSEUDO_VAR_NBR}++;

    $self->{VAR_INIT_VAL}->{$self->{CUR_PSEUDO_VAR}} = ();
    $self->{VAR_TYPES}->{$self->{CUR_PSEUDO_VAR}} = "real";
    
    foreach my $data (@{$self->{VAR_INIT_VAL}->{$right_op}}) {
	push @{$self->{VAR_INIT_VAL}->{$self->{CUR_PSEUDO_VAR}}}, [eval("$left_op $operator $data->[0]"), $data->[1]]
    }
}

sub arithm_calc_var_num {
    my ($self, $left_op, $right_op, $operator) = @_;

    $self->{CUR_PSEUDO_VAR} = "_pseudovar".$self->{PSEUDO_VAR_NBR};
    $self->{PSEUDO_VAR_NBR}++;

    $self->{VAR_INIT_VAL}->{$self->{CUR_PSEUDO_VAR}} = ();
    $self->{VAR_TYPES}->{$self->{CUR_PSEUDO_VAR}} = "real";
    
    foreach my $data (@{$self->{VAR_INIT_VAL}->{$left_op}}) {
	push @{$self->{VAR_INIT_VAL}->{$self->{CUR_PSEUDO_VAR}}}, [eval("$data->[0] $operator $right_op"), $data->[1]]
    }
}
