#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Equation/PropertiesParser.pm,v 1.5 2001/09/26 15:44:53 lsimonneau Exp $
##*****************************************************************************
## Class PropertiesParser 
##  Description  : The equation parser for fonctions properties collection 
##                 (see EquationParser.pm)
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: PropertiesParser.pm,v $
#Revision 1.5  2001/09/26 15:44:53  lsimonneau
#Reimplementation of the Equation parser.
#
#Revision 1.4  2001/07/25 12:00:47  lsimonneau
#Ajout du support des equations arithmtiques sur les variables en argument des fonctions de detection.
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm::Equation::PropertiesParser;

use strict;
use LogTrend::ComplexAlarm::Equation::EquationParser;
use LogTrend::ComplexAlarm::Function::FunctionLoader;

@LogTrend::ComplexAlarm::Equation::PropertiesParser::ISA = ("LogTrend::ComplexAlarm::Equation::EquationParser");

##*****************************************************************************
## Constructor  public
##  Description  : creat a new PropertiesParser
##  Parameters   : the equation string
##*****************************************************************************
sub new
{
    my ($classname, $equation) = @_;
    my $self = $classname->SUPER::new($equation);
    
    bless($self, $classname);
    
    return $self;
}


##*****************************************************************************
## Method FUNCTION virtual protected
##  Description  : Called by the parser when a function is parsed.
##  Parameters   : The function name
##                 The list of arguments name.
##*****************************************************************************
sub FUNCTION
{
    my ($self, $funcname, @arglist) = @_;
    my ($timestring, @varlist);

    my @result;
    
  LogTrend::ComplexAlarm::Function::FunctionLoader::LoadFunction("$funcname");       

    ($timestring, @varlist)=eval("LogTrend::ComplexAlarm::Function::${funcname}".'::Properties(@arglist)');
    
    @result = ($timestring, @varlist);
    return \@result;
}

##*****************************************************************************
## Method APPLY_AND virtual protected
##  Description  : Called by the parser when an AND operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_AND
{    
    my ($self, $left_list, $right_list) = @_;
    my ($left_timestring, @left_var_list) = @$left_list;
    my ($right_timestring, @right_var_list) = @$right_list;
        
    my @varlist = (@left_var_list, @right_var_list);
    my @result;

    if(($right_timestring eq "") and $left_timestring eq "") {
	@result = ("", @varlist);
    }
    elsif(($left_timestring eq "") and not ($right_timestring eq "")) {
	@result = ($right_timestring, @varlist);
    }
    elsif(($right_timestring eq "") and not ($left_timestring eq "")) {
	@result = ($left_timestring, @varlist);
    }
    else {	
	@result = ("(($left_timestring) AND ($right_timestring))", @varlist);
    }

    return \@result;
}

##*****************************************************************************
## Method APPLY_OR virtual protected
##  Description  : Called by the parser when an OR operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_OR
{
    my ($self, $left_list, $right_list) = @_;
    my ($left_timestring, @left_var_list) = @$left_list;
    my ($right_timestring, @right_var_list) = @$right_list;
    
    my @varlist = (@left_var_list, @right_var_list);
    my @result;

    if($right_timestring eq "" and $left_timestring eq "") {
	@result = ("", @varlist);
    }    
    elsif($left_timestring eq "" and not ($right_timestring eq "")) {
	@result = ($right_timestring, @varlist);
    }
    elsif($right_timestring eq "" and not ($left_timestring eq "")) {
	@result = ($left_timestring, @varlist);
    }
    else {
	@result = ("(($left_timestring) OR ($right_timestring))", @varlist);
    }
    return \@result;
}

##*****************************************************************************
## Method APPLY_NOT virtual protected
##  Description  : Called by the parser when an NOT operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_NOT
{
    my ($self, $list) = @_;
    my ($timestring, @var_list) = @$list;

    my @result;

    if($timestring eq ""){
	@result = ("", @var_list);
    }
    else {
	@result = ("NOT ($timestring)", @var_list);
    }

    return \@result;
}


##*****************************************************************************
## Method APPLY_PLUS virtual protected
##  Description  : Called by the parser when an + arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_PLUS
{
    my ($self, $left_op, $right_op) = @_;
    my $result = "";

    if($left_op !~ /^\d+(\.\d+)?$/) {
	$result = "$left_op";
    }

    if($right_op !~ /^\d+(\.\d+)?$/) {
	$result .= ":" if $result ne "";
	$result .= $right_op;
    }

    return "$result";
}

##*****************************************************************************
## Method APPLY_MINUS virtual protected
##  Description  : Called by the parser when an - arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_MINUS
{
    return APPLY_PLUS(@_);
}


##*****************************************************************************
## Method APPLY_MULT virtual protected
##  Description  : Called by the parser when an * arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_MULT
{
    return APPLY_PLUS(@_);
}


##*****************************************************************************
## Method APPLY_DIV virtual protected
##  Description  : Called by the parser when an / arithmetic operator is parsed.
##  Parameters   : none
##*****************************************************************************
sub APPLY_DIV
{
    return APPLY_PLUS(@_);
}
