#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/ComplexAlarm/Parser.pm,v 1.3 2001/09/26 16:01:48 lsimonneau Exp $
##*****************************************************************************
## Class Parser 
##  Description  : Search tokens in a string.
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: Parser.pm,v $
#Revision 1.3  2001/09/26 16:01:48  lsimonneau
#Reimplementation of Equation parser.
#
#Revision 1.2  2001/06/21 16:07:13  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.1  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::ComplexAlarm::Parser;

use strict;

##*****************************************************************************
## Constructor  public
##  Description  : creat a new Parser
##  Parameters   : the string to parse and the token list. This list is a 
##                 list of regular expression describing the valid token of 
##                 the string
##*****************************************************************************
sub new
{
    my ($classname, $string, @token_list) = @_;
    my $self = {};

    bless($self, $classname);

    $self->{STRING} = $string;
    push @{$self->{TOKENS}}, @token_list;
    
    return $self;
}


##*****************************************************************************
## Method NextToken public
##  Description  : Return a list with : 
##                 - The next token id (place of the toen in the list passed 
##                   to new) or -1 in the next token is unknown.
##                 - The token string
##                 When all the string is parsed, ($#tokenlist+1, "") 
##                 is returned;
##  Parameters   : none
##*****************************************************************************
sub NextToken
{
    my $self = shift;
    my $token;
    my $index=0;
    
    # remove spaces 
    $self->{STRING} =~ s/^\s*//g;

    if($self->{STRING} eq "") {
	$self->{CURTOKEN_STR} = "END OF STRING";
	$self->{CURTOKEN_IDX} = $#{$self->{TOKENS}}+1;
	return ($#{$self->{TOKENS}}+1, "");
    }

    # look for a token 
    foreach $token (@{$self->{TOKENS}}) {
	if($self->{STRING} =~ s/^$token//){
	    $self->{CURTOKEN_STR} = $&;
	    $self->{CURTOKEN_IDX} = $index;
	    return ($index, $&);
	}

	$index++;
    }
    
    return (-1, $self->{STRING});
}


##*****************************************************************************
## Method NextToken public
##  Description  : Return a list with : 
##                 - The next token id (place of the toen in the list passed 
##                   to new) or -1 in the next token is unknown.
##                 - The token string
##                 When all the string is parsed, ($#tokenlist+1, "") 
##                 is returned;
##  Parameters   : none
##*****************************************************************************
sub CurToken {
    my $self = shift;
    
    return ($self->{CURTOKEN_IDX}, $self->{CURTOKEN_STR});
}

1;
