#!/usr/bin/perl

#$Header: /var/lib/cvs/LogTrend/Consolidation/Rules/RulesStdLib.pm,v 1.2 2001/09/27 14:30:05 lsimonneau Exp $
##*****************************************************************************
##  RulesStdLib 
##  Description  : Standard Consolidation Rules 
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: RulesStdLib.pm,v $
#Revision 1.2  2001/09/27 14:30:05  lsimonneau
#DIsable autocommit for DataBase and add Commit methods to Consolidation/ConsolidationPostgreSQLDataBase.pm to prevent data lost on die or sigtrem, sigint ...
#
#Revision 1.1  2001/08/22 09:51:27  lsimonneau
#First usable version of Consolidation.
#



##*****************************************************************************
##  Mean 
##  Description  : Mean Rule. 
##  
##*****************************************************************************

package LogTrend::Consolidation::Rules::Mean;

sub Run {
    my ($data_list, $factor) = @_;

    my $cur_factor = 1;
    my $sum = 0;
    my $date_sum;
    my @result;

    for(my $i=0; defined $data_list->[$i]; $i++) {
	$sum += $data_list->[$i]->[0];
	$date_sum += $data_list->[$i]->[1];
	
	if($cur_factor == $factor) {
	    push @result, [$sum/$factor, int($date_sum/$factor)];
	    $cur_factor = 0;
	    $sum = 0;
	    $date_sum = 0;
	}
	$cur_factor++;
    }

    return \@result;
}


##*****************************************************************************
##  Max
##  Description  : Max Rule. 
##  
##*****************************************************************************

package LogTrend::Consolidation::Rules::Max;

sub Run {
    my ($data_list, $factor) = @_;

    my $cur_factor = 1;
    my ($max, $date_max) = @{$data_list->[0]} if defined $data_list->[0];
    my @result;

    for(my $i=0; defined $data_list->[$i]; $i++) {
	if($max < $data_list->[$i]->[0]) {
	    ($max, $date_max) = @{$data_list->[$i]};
	}
	
	if($cur_factor == $factor) {
	    push @result, [$max, $date_max];
	    $cur_factor = 0;
	    ($max, $date_max) = @{$data_list->[$i+1]} if defined $data_list->[$i+1];
	}
	$cur_factor++;
    }

    return \@result;
}

##*****************************************************************************
##  Min
##  Description  : Min Rule
##  
##*****************************************************************************

package LogTrend::Consolidation::Rules::Min;

sub Run {
    my ($data_list, $factor) = @_;

    my $cur_factor = 1;
    my ($min, $date_min) = @{$data_list->[0]} if defined $data_list->[0];
    my @result;

    for(my $i=0; defined $data_list->[$i]; $i++) {
	if($min > $data_list->[$i]->[0]) {
	    ($min, $date_min) = @{$data_list->[$i]};
	}
	
	if($cur_factor == $factor) {
	    push @result, [$min, $date_min];
	    $cur_factor = 0;
	    ($min, $date_min) = @{$data_list->[$i+1]} if defined $data_list->[$i+1];
	}
	$cur_factor++;
    }

    return \@result;
}

1;
