#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/bin/genkeys.pl,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
##  genkeys.pl
##  Description  : script generating a RSA key pair
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##******************************************************************************
#$Log: genkeys.pl,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.3  2001/12/10 16:58:34  lsimonneau
#Use GnuPG::Interface instead of Crypt::RSA for perl 5.005 compatibility.
#
#Revision 1.2  2001/11/20 16:28:30  lsimonneau
#Change use Getopt::Long for more compatibility with standard debian potato packages.
#
#Revision 1.1  2001/11/16 10:28:09  lsimonneau
#First version of this modules.
#Used for RSA signature authentication.
#

use Getopt::Long;
use POSIX qw(tmpnam);

sub display_help_and_exit {
    my $exit_status = shift;

    print "\nUsage: genkeys.pl -g <gpg_home_dir> -f <filename> -i <identity>\n",
          "                    -c <comments added to the key description>\n\n",
          "Options:\n",
          "   -g, --gpghome       The gpg home dir (default is /etc/LogTrent/.gnupg)\n",
          "   -c, --comment       Comment added to the key description\n",
          "   -e, --email         Email addes to the key description\n\n";

    exit($exit_status);
}

my($opts) = {};
 
Getopt::Long::Configure("bundling", "no_ignore_case");

GetOptions($opts, 'gpghome|g=s',
  	          'comment|c=s',
  	          'email|e=s',
 	          'help|h')
    or  display_help_and_exit(1);


display_help_and_exit(0) if exists $opts->{help};

my $gpghome = $opts->{gpghome};
my $comment = $opts->{comment};
my $email = $opts->{email};

if(! exists $opts->{gpghome}) {
    $gpghome = "/etc/LogTrend/.gnupg";
    if(! -x $gpghome) {
        print "$gpghome does not exists, try to create this directory ...";
        if(mkdir($gpghome, 0700)) {
            print " OK\n";
        }
        else {
            print " failed\n";
            die "Can't create $gpghome : $!";
        }
    }
}

if(! -d $gpghome) {
    die "$gpghome does not exists";
}

my $cmd_filename = tmpnam;
open(CMD_FILE, ">$cmd_filename")
    or die "Can't create $cmd_filename : $!";


my $time = localtime;

print CMD_FILE 
    "\%echo Generating the keys pair\n",
    "Key-Type: DSA\n",
    "Key-Length: 1024\n",
    "Subkey-Type: ELG-E\n",
    "Subkey-Length: 1024\n",
    "Name-Real: LogTrend Source $time\n",
    defined $comment ? "Name-Comment: $comment\n":"",
    defined $email ? "Name-Email: $email\n":"",
    "Expire-Date: 0\n",
    "\%commit\n",
    "\%echo done\n";

close CMD_FILE;    

system ("gpg --homedir $gpghome --gen-key --batch -a $cmd_filename");
    
print "Use : 'gpg --homedir $gpghome --armor --export \"LogTrend Source $time\"' to export the public key\n";

unlink($cmd_filename);
