#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Action/SMS.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##*****************************************************************************
##  Class SMS
##  Description  : Send an SMS 
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: SMS.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.2  2001/11/02 13:55:42  lsimonneau
#Add Action support for agents' alarms.
#Add action support for LinuxAgent Process alarms.
#
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#
#Revision 1.3  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.2  2001/06/07 14:41:04  lsimonneau
#Passage du unshift @INC, '..' au LogTrend::
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package LogTrend::Action::SMS;

use strict;
use LogTrend::Action::SMS::SMSSender;
use LogTrend::Action;

@LogTrend::Action::SMS::ISA = ("LogTrend::Action");

##*****************************************************************************
## Constructor  public
##  Description  : creat a new SMS
##  Parameters   : The XML node.
##*****************************************************************************
sub new 
{
    my ($classname, $xml_node) = @_;
    my $self = $classname->SUPER::new();
    
    bless($self, $classname);
    
    $self->ParseXMLAction($xml_node);
    
    $self->{SENDER} = LogTrend::Action::SMS::SMSSender->new($self->{PHONE_NAT}, 
									  $self->{PHONE_INTER}, 
									  $self->{MESSAGE});

    return $self;
}


##*****************************************************************************
## Method ParseXMLAction private
##  Description  : Run the action
##  Parameters   : none
##*****************************************************************************
sub ParseXMLAction
{
    my ($self, $node) = @_;
    my ($list, $attributes, $attrnode);
    
    $attributes = $node->getAttributes() || die("Error in \"SMS\" tag.");
    $attrnode = $attributes->getNamedItem("NationalPhone") ||
	die("SMS: No 'NationalPhone' field in \"SMS\" tag.");
    $self->{PHONE_NAT}=$attrnode->getValue();
    
    $attrnode = $attributes->getNamedItem("InternationalPhone") ||
	die("SMS: No 'InternationalPhone' field in \"SMS\" tag.");
    $self->{PHONE_INTER}=$attrnode->getValue();

    $list = $node->getChildNodes();        
    $node = $list->item(0) or die("SMS: invalid \"SMS\" Tag");
    
    $self->{MESSAGE} = $node->getNodeValue();

}





##*****************************************************************************
## Method Run public
##  Description  : Run the action
##  Parameters   : the alarm level
##*****************************************************************************
sub Run 
{
    my ($self, $alarm_level) = @_;
    
    $self->{MESSAGE} = "LogTrend -- $alarm_level -- $self->{MESSAGE}";
    $self->{SENDER}->Send();
}

1;
