#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Action/SMS/genie.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $

##*****************************************************************************
##  genie.pm
##  Description  : Specific function for www.genie.fr Free sms service
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************

package genie;

use strict;
use LWP;
use HTTP::Request;
use HTTP::Response;
use HTTP::Cookies;

##*****************************************************************************
##  get_jscript_cookies (a Postrequest function)
##  Description  : create cookies form the java script data
##
##  Parameters   : none
##*****************************************************************************
sub get_jscript_cookies {
    my ($user_agent, $request, $response) = @_;
    my $url = $response->request->url;
    my $req_port = $url->port;
    my $html_data = $response->content;

    my $cookie_jar = $user_agent->cookie_jar;

    while($html_data =~ s/document\.cookie = "(\w+)" \+ "=" \+ escape\("(.+)"\)\s?\+ "\; path=(.+)\; domain=(.+)\;"\;//) {
	$cookie_jar->set_cookie(0, $1, $2, $3 ,$4, undef, 1, undef, undef, 1);
    }
}

1;
