#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/Alarm.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class Alarm
##  Description  : class to stock an alarm
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: Alarm.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.5  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.4  2001/03/05 14:43:09  slhullier
#
#Bug alarm (")
#
#Revision 1.3  2001/02/22 17:02:23  slhullier
#
#Gestion des systemes de fichiers par LinuxAgent.
#Premiers tests concluants, reste a ajouter des alarmes et a faire
#des tests en situation reelle.
#
#Revision 1.2  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.1.1.1  2001/02/06 09:48:27  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

package LogTrend::Agent::Alarm;

##******************************************************************************
## Constructor  public
##  Parameters   : the alarm number
##******************************************************************************
sub new
{
   my ($classname, $number) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{NUMBER} = $number;
   return $self;
}

##******************************************************************************
## Method GetType  public
##  Description  : returns the current alarm number
##******************************************************************************
sub GetNumber
{
   my $self = shift;
   return $self->{NUMBER};
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the alarm in xml
##  Parameters   : none
##  Return value : an xml string representation of the alarm
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;
   my $result = "<A N=\"".$self->{NUMBER}."\"\/>";
   return $result;
}

##******************************************************************************
1;
