#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/DataDescription.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class DataDescription
##  Description  : class for a data description
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: DataDescription.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.8  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.7  2001/02/27 17:10:03  slhullier
#
#Ajout des quotas : nombre d'users/groups qui depassent.
#Semble fonctionner, a tester en grandeur reelle.
#
#Revision 1.6  2001/02/22 17:02:23  slhullier
#
#Gestion des systemes de fichiers par LinuxAgent.
#Premiers tests concluants, reste a ajouter des alarmes et a faire
#des tests en situation reelle.
#
#Revision 1.5  2001/02/21 09:27:06  slhullier
#
#Avant ajout de l'info dans le fichier de description de l'agent
#
#Revision 1.4  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.3  2001/02/20 15:08:56  slhullier
#
#Avant modification de quelques noms de fichiers.
#
#Revision 1.2  2001/02/20 10:21:55  slhullier
#
#Passage de la fonction de parsage de config XML dans Agent.pm
#Creation des tags Generic et Specific
#Fichiers agentdescription.xml plus lisibles (avec \n)
#Supression de methodes pas appellee du fichier Agent.pm
#
#Revision 1.1.1.1  2001/02/06 09:48:27  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

package LogTrend::Agent::DataDescription;

##******************************************************************************
## Constructor  public
##  Description  : creat a new DataDescription
##  Parameters   : the data number, the data type, the data unit,
##                 an information message describing the data, an internal-info
##******************************************************************************
sub new
{
   my ($classname, $number, $type, $unit, $description, $internal) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{NUMBER} = $number;
   $self->{TYPE} = $type;
   $self->{UNIT} = $unit;
   $self->{DESCRIPTION} = $description;
   if( !defined($internal) || $internal eq "" )
   { $self->{INTERNAL} = $description; }
   else
   { $self->{INTERNAL} = $internal; }
   return $self;
}

##******************************************************************************
## Method GetNumber  public
##  Description  : returns the current data description number
##******************************************************************************
sub GetNumber
{
   my $self = shift;
   return $self->{NUMBER};
}

##******************************************************************************
## Method GetType  public
##  Description  : returns the current data description type
##******************************************************************************
sub GetType
{
   my $self = shift;
   return $self->{TYPE};
}

##******************************************************************************
## Method GetUnit  public
##  Description  : returns the current data description unit
##******************************************************************************
sub GetUnit
{
   my $self = shift;
   return $self->{UNIT};
}

##******************************************************************************
## Method GetDescription  public
##  Description  : returns the current data description description
##******************************************************************************
sub GetDescription
{
   my $self = shift;
   return $self->{DESCRIPTION};
}

##******************************************************************************
## Method GetInternal  public
##  Description  : returns the current data description internal-info
##******************************************************************************
sub GetInternal
{
   my $self = shift;
   return $self->{INTERNAL};
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the data description in xml
##  Parameters   : none
##  Return value : an xml string representation of the data description
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;

   my $result = "<Data><Number>".$self->{NUMBER}."</Number><Type><".$self->{TYPE}.
                "/></Type><Unit>".$self->{UNIT}."</Unit>\n".
                "   <Description>".$self->{DESCRIPTION}."</Description>\n".
                "   <Internal>".$self->{INTERNAL}."</Internal></Data>\n";

   return $result;
}

##******************************************************************************
1;
