#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/SimpleAgent.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class SimpleAgent  isa  Agent
##  Description  : class for an example of Agent
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: SimpleAgent.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.4  2001/11/20 16:28:30  lsimonneau
#Change use Getopt::Long for more compatibility with standard debian potato packages.
#
#Revision 1.3  2001/07/23 13:42:51  fdesar
#Better example for ParseAgentOptions method
#
#Revision 1.2  2001/07/23 13:29:40  fdesar
#Added commented ParseAgentOptions method to handle extra-options specific
#to agent
#
#Revision 1.1  2001/07/19 16:40:27  fdesar
#
#Moved module files to the right directories
#Updated package names and uses to reflect those changes
#Corrected bug in SnortAgent.pm for negating first value in SID parsing
#
#Revision 1.15  2001/07/10 12:55:17  slhullier
#*** empty log message ***
#
#Revision 1.14  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.13  2001/03/19 10:57:58  slhullier
#
#Agents : fichier de conf par defaut dans /etc   +  mise en commun
#des routines de gestion des arguments dans Agent.pm
#
#Revision 1.12  2001/03/14 09:10:46  slhullier
#
#Die moins stupides
#
#Revision 1.11  2001/03/13 09:44:11  slhullier
#
#SimpleAgent mis au gout du jour
#
#Revision 1.10  2001/03/13 09:10:23  slhullier
#
#LogDie sur SimpleAgent + version&number dans Configuration.xml
#
#Revision 1.9  2001/03/08 17:33:54  slhullier
#
#L'agent ne meurt plus des que le serveur ne repond plus.
#
#Revision 1.8  2001/03/07 10:34:04  slhullier
#
#Mise en place de LogDie dans l'agent Linux
#
#Revision 1.7  2001/02/22 17:02:23  slhullier
#
#Gestion des systemes de fichiers par LinuxAgent.
#Premiers tests concluants, reste a ajouter des alarmes et a faire
#des tests en situation reelle.
#
#Revision 1.6  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.5  2001/02/20 15:50:20  slhullier
#
#Apres modification du nom de certaines classes
#
#Revision 1.4  2001/02/20 10:21:55  slhullier
#
#Passage de la fonction de parsage de config XML dans Agent.pm
#Creation des tags Generic et Specific
#Fichiers agentdescription.xml plus lisibles (avec \n)
#Supression de methodes pas appellee du fichier Agent.pm
#
#Revision 1.3  2001/02/08 15:29:27  slhullier
#
#
#Changement de repertoire pour SimpleAgent.pl (SimpleAgent)
#
#Revision 1.2  2001/02/07 14:36:33  slhullier
#
#
#Le systeme MailBridge fonctionne.
#Mise en service sur spa.
#
#Revision 1.1.1.1  2001/02/06 09:48:27  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

package LogTrend::Agent::SimpleAgent;

use strict;

use vars qw( @ISA );

use LogTrend::Agent;
use LogTrend::Common::LogDie;

@ISA = ("LogTrend::Agent");

my $name = "SimpleAgent";
my $version = "1.0.0.0";

##******************************************************************************
## Constructor  public > Agent
##  Description  : creat a new SimpleAgent
##  Parameters   : none
##******************************************************************************
sub new
{
   my ( $classname ) = @_;

   my $self = $classname->SUPER::new( $name, $version );
   bless($self, $classname);
   srand( time() );
   return $self;
}

##******************************************************************************
## Method ParseAgentOptions  public  (>Agent)
##  Description  : parses agent specific switches (overload to enable)
##  Parameters   : none
##  Return value : none
##******************************************************************************
#sub ParseAgentOptions {
#
#    use Getopt::Long;
#
#    my($self) = shift;
#    my($opts) = {};
#
#        GetOptions($opts, 'foo|f', 'bar|b=s', 'zork|z=i')
#    or  do {
#        print "Usage: blah, blah...";
#        exit(1);
#    };
#    $self->{Options} = $opts;
#
#        exists($self->{Options}{bar}
#    and print "Option 'bar' has value: ", $self->{Options}{bar}, "\n";
#}

##******************************************************************************
## Method ParseXMLConfigFile  public  (>Agent)
##  Description  : parses the XML config file
##  Parameters   : the file name to parse, the agent state
##  Return value : none
##******************************************************************************
sub ParseXMLConfigFile
{
   my $self = shift;
   my $file = shift;
   my $agentstate = shift;
   $self->SUPER::ParseXMLConfigFile( $file );

   ##***************************************************************************
   ## Agent-specific configuration parameters :
   ## use $self->{FOO} to stock information ( all $self->{_FOO} are reserved )
   ##***************************************************************************
   my ($list,$node,$valueref,$attributes,$attrnode);

   ##===========================================================================
   ## Tag 'Configuration'
   ##===========================================================================
   my $parser = new XML::DOM::Parser() || Die($!);
   my $doc = $parser->parsefile( $file ) || Die($!);

   my $rootlist = $doc->getElementsByTagName("Configuration") ||
                                               Die("No \"Configuration\" tag.");
   my $rootnode = $rootlist->item(0) || Die("No \"Configuration\" tag.");

   ##===========================================================================
   ## Tag 'Specific'
   ##===========================================================================
   $rootlist = $rootnode->getElementsByTagName("Specific") ||
                                        Die("No \"Specific\" tag.");
   $rootnode = $rootlist->item(0) || Die("No \"Specific\" tag.");

   ##===========================================================================
   ## Tag 'Yellow'
   ##===========================================================================
   $list = $rootnode->getElementsByTagName("Yellow") || Die("$file: No \"Yellow\" tag.");
   $node = $list->item(0) || Die("No \"Yellow\" tag.");
   $attributes = $node->getAttributes() || Die("$file: Error in \"Yellow\" tag.");

   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("Limit") ||
                   Die("$file: No 'Limit' field in \"Yellow\" tag.");
   $self->{"Cfg_Limit"} = $attrnode->getValue();

   ##---------------------------------------------------------------------------
   $attrnode = $attributes->getNamedItem("Interval") ||
             Die("$file: No 'Interval' field in \"Yellow\" tag.");
   $self->{"Cfg_Interval"} = $attrnode->getValue();



   $parser = undef;
}

##******************************************************************************
## Method CreateAgentDescription  public  (>Agent)
##  Description  : creates an agent's description
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub CreateAgentDescription
{
   my $self = shift;
   my ($d,$a) = (1,1);

   $self->AddADataDescription($d++, "Integer", "bytes", "blue foo");
   $self->AddADataDescription($d++, "Real",    "none",   "red foo", "red_foo");
   $self->AddADataDescription($d++, "Text",    "none", "green foo");
   $self->AddAnAlarmDescription($a++, "Warning", "yellow foo", "yellow_foo");
}

##******************************************************************************
## Method CollectData  public  (>Agent)
##  Description  : collects data and alarms
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub CollectData
{
   my $self = shift;

   $self->AddDataInteger( $self->{"blue foo"}, 333 );
   $self->AddDataReal(    $self->{"red_foo"}, 4.5 );
   $self->AddDataText(    $self->{"green foo"}, "foo" );

   if( rand($self->{"Cfg_Interval"}) < $self->{"Cfg_Limit"} )
   {
      $self->AddAlarm( $self->{"yellow_foo_Warning"} );
   }

}

##******************************************************************************
1;
