#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Crypto/PostgreSQLDataBase.pm,v 1.1 2002/04/10 01:18:48 jdive Exp $
##******************************************************************************
## PostgreSQLDataBase (ISA LogTrend::DataBaseAcces::PostgreSQLDataBase and
##                         Crypto::DataBase)
##  Description  : Methods for PostgreSQL Database access
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##
##******************************************************************************
#$Log: PostgreSQLDataBase.pm,v $
#Revision 1.1  2002/04/10 01:18:48  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.2  2001/12/10 16:58:34  lsimonneau
#Use GnuPG::Interface instead of Crypt::RSA for perl 5.005 compatibility.
#
#Revision 1.1  2001/11/16 10:28:09  lsimonneau
#First version of this modules.
#Used for RSA signature authentication.
#

package LogTrend::Crypto::PostgreSQLDataBase;

use strict;
use Error qw(:try);
use LogTrend::Crypto::DataBase;
use DBI;
use LogTrend::Crypto::ErrorDeclaration;

@LogTrend::Crypto::PostgreSQLDataBase::ISA = qw(LogTrend::Crypto::DataBase);


##*****************************************************************************
## Constructor  public
##  Description  : creat a new database access interface
##
##  Parameters   : The database name,
##                 The database server host name,
##                 The database server port,
##                 An username and a password of a database user
##
##  Throw errors : Error::DB_Connection
##*****************************************************************************
sub new
{
    my ($classname, $databasename, $host, $port, $username, $password) = @_;

    my $self = $classname->SUPER::new($databasename, $host, $port, $username, $password);

    bless($self, $classname);

    return $self;
}


##*****************************************************************************
## connect protected
##  Description  : Try to establish a connection with the database
##  Parameters   : none
##*****************************************************************************
sub connect
{
    my ($self, $databasename, $host, $port, $username, $password) = @_;

    die("Already connected") if defined $self->{DBHANDLE};

    my $ConnectionParameters = "dbi:Pg:dbname=$databasename";
    
    # Build the connection parametres
    # dbi:Pg:dbname=logtrend;host=serveur.orsay.atrid.fr;port=5432
    $ConnectionParameters = $ConnectionParameters.";host=".$host;
    
    $ConnectionParameters = $ConnectionParameters.";port=".$port;
    
    # Connect to the DB
    my $db_handle = DBI->connect($ConnectionParameters, $username, $password, {PrintError => 0});
    
    my $result = 0;
    if (!defined $db_handle) {
	throw Error::DB_Connection($DBI::errstr);
    }

    $self->{DBHANDLE} = $db_handle;
}

##*****************************************************************************
## disconnect protected
##  Description  : Disconnect from the database
##  Parameters   : none
##*****************************************************************************
sub disconnect
{
    my $self = shift;
    
    if(defined $self->{DBHANDLE}) {
        $self->{DBHANDLE}->disconnect()
	    or throw Error::DB_Connection($self->{DBHANDLE}->errstr);
    }
}


##*****************************************************************************
## Method getListOfKeys  public
##  Description  : Return the list off sources' RSA keys
##
##  Parameters   : none
##
##  Return : a list of [rsa_ssh_key, source_id]
##
##  Throw errors : Error::DB_Request
##
##*****************************************************************************
sub getListOfKeys {    
    my $self = shift;
    my $dbh = $self->{DBHANDLE};

    my $sth = $dbh->prepare("SELECT public_key, id_source FROM sources WHERE public_key IS NOT NULL")
	or throw Error::DB_Request($dbh->errstr);

    $sth->execute 
	or throw Error::DB_Request($dbh->errstr);

    my $rows = $sth->fetchall_arrayref;

    if(defined $dbh->err) {
	throw Error::DB_Request($dbh->errstr);
    }

    return $rows;    
}
