#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Agent/AgentDescriptionToDB/DBAbstractionLayer.pm,v 1.6 2001/11/16 10:32:28 lsimonneau Exp $
#
#
#$Log: DBAbstractionLayer.pm,v $
#Revision 1.6  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.5  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.4  2001/07/27 14:41:23  lsimonneau
#Include UpdateAgentDescription in AgentDescriptionToDB.
#
#Revision 1.3  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.2  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.1.1.1  2001/02/06 09:48:28  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

use strict;

package LogTrend::Agent::AgentDescriptionToDB::DBAbstractionLayer;

#***********************************************************************
#                                                                      *
# DBAbstractionLayer is an abstract class that mustn't be instanciated *
#                                                                      *
#***********************************************************************

#**************************************************************************
#
# status : public
#
# function : constructor
#
# parameters :
#
# databasename : the name of the database
# host : the name or the IP of the host of the database server
# port : the port on which the database server is listening for connections
# username : the name of a database user
# password : the password of a database user
#
# returns : a reference to an instance of the class
#
#**************************************************************************

sub new
  {
    my ($classname, $databasename, $host, $port, $username, $password) = @_;
    my $self = {};
    bless($self, $classname);
    $self->{DATABASENAME} = $databasename;
    $self->{HOST} = $host;
    $self->{PORT} = $port;
    $self->{USERNAME} = $username;
    $self->{PASSWORD} = $password;
    
    $self->connect;

    return $self;
}

#********************************************************************************
#
# status : public
#
# function : starts the connection to the LogTrend database on a database server
#
# parameters : none
#
# returns : 1 if succesfull and 0 otherwise
#
#********************************************************************************

sub Connect
  {
  }

#****************************************************************
#
# status : public
#
# function : achieves the diconnection from a database server
#
# parameters : none
#
# returns : 1 if successfull and 0 otherwise
#
#****************************************************************

sub Disconnect
  {
  }

#***************************************************************************
#
# status : public
#
# function : adds an agent to the LogTrend database
#
# parameters :
#
# agentsource : the agent's source
# agentnumber : the agent's number
# agentversion : the agent's version
# activationdate : the agent's activation date
# agentinformation : the agent's informations
#
# returns : 1 if successfull and in the errors case :
#
# -1 if the source is not existing
# -2 if the agent is already in the database
# -3 if the add of the agent has aborted
#
#***************************************************************************

sub AddAgent
  {
  }

#************************************************************
#
# status : public
#
# function : adds a description associated to an agent's data
#
# parameters :
#
# agentsource : the agent's source
# agentnumber : the agent's number
# agentversion : the agent's version
# activationdate : the agent's activation date
# number : a data's number
# type : a data's type
# unit : a data's unit
# description : a data's description
#
# returns : 1 if succesfull and 0 otherwise
#
#************************************************************

sub AddDataDescription
  {
  }

#*************************************************************
#
# status : public
#
# function : adds a description associated to an agent's alarm
#
# parameters :
#
# agentsource : the agent's source
# agentnumber : the agent's number
# agentversion : the agent's version
# activationdate : the agent's activation date
# number : an alarm's number
# level : an alarm's level
# message : an alarm's message
#
# returns : 1 if succesfull and 0 otherwise
#
#************************************************************

sub AddAlarmDescription
  {
  }



sub DESTROY {
    my $self = shift;

    $self->disconnect;
}
1;
