#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Crypto/DataBase.pm,v 1.1 2001/11/16 10:28:09 lsimonneau Exp $
##******************************************************************************
## DataBase
##  Description  : Methods for DataBase access (abstract class)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##
##******************************************************************************
#$Log: DataBase.pm,v $
#Revision 1.1  2001/11/16 10:28:09  lsimonneau
#First version of this modules.
#Used for RSA signature authentication.
#


use strict;
use Error qw(:try);

@Error::DB_Request::ISA = qw(Error::Simple);
@Error::DB_Connection::ISA = qw(Error::Simple);
@Error::DB_Login::ISA = qw(Error::Simple);

package LogTrend::Crypto::DataBase;



##*****************************************************************************
## Constructor  public
##  Description  : creat a new database access interface
##
##  Parameters   : The database name,
##                 The database server host name,
##                 The database server port,
##                 An username and a password of a database user
##
##  Throw errors : Error::DB_Request
##                 Error::DB_Connection
##*****************************************************************************
sub new
{
    my ($classname, $databasename, $host, $port, $username, $password) = @_;
    my $self = {};
    
    bless($self, $classname);

    $self->connect($databasename, $host, $port, $username, $password);
    
    return $self;
}


##*****************************************************************************
## connect protected
##  Description  : Try to establish a connection with the database
##  Parameters   : none
##*****************************************************************************
sub connect
{
}


##*****************************************************************************
## disconnect protected
##  Description  : Disconnect from the database
##  Parameters   : none
##*****************************************************************************
sub disconnect
{
}

##*****************************************************************************
## Method getListOfKeys  public
##  Description  : Return the list off sources' RSA keys
##
##  Parameters   : none
##
##  Return : a list of [rsa_ssh_key, source_id]
##
##  Throw errors : Error::DB_Request
##
##*****************************************************************************
sub getListOfKeys {    
}


##*****************************************************************************
##  DESTROY public
##  Description  : Automatically disconnect form the database when object 
##                 is destroyed
##*****************************************************************************

sub DESTROY {
    my $self = shift;
    $self->disconnect() if( defined( $self ) );
}

