#$Header: /home2/cvsroot/LogTrend/Visu/ApacheModule.pm,v 1.28 2002/01/02 10:18:39 slhullier Exp $
##******************************************************************************
## Module ApacheModule
##  Description  : an Apache module for LogTrendVisu
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: ApacheModule.pm,v $
#Revision 1.28  2002/01/02 10:18:39  slhullier
#http://host/LogTrendVisu works
#
#Revision 1.27  2001/12/27 17:10:25  slhullier
#Plugins 1st step
#
#Revision 1.26  2001/11/28 17:29:05  slhullier
#No more session ...
#
#Revision 1.25  2001/11/27 16:04:51  slhullier
#User added in URL
#
#Revision 1.24  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.23  2001/10/15 07:58:22  slhullier
#In english
#
#Revision 1.22  2001/10/03 09:21:35  slhullier
#New name for some variables
#
#Revision 1.21  2001/09/27 16:06:40  slhullier
#Configuration by XML file works.
#
#Revision 1.20  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.19  2001/09/07 13:22:17  lsimonneau
#Add support of URL like http://myserver.com/LogTrendVisu/MyClientName/TheNetwork/
#
#Revision 1.18  2001/08/23 12:40:47  slhullier
#
#Error message more lovely
#
#Revision 1.17  2001/08/13 15:02:18  slhullier
#
#CGI parameters communication via XML protocols
#
#Revision 1.16  2001/08/10 14:47:29  slhullier
#
#Begining of URL XML-encoding ; stable but not finished
#
#Revision 1.15  2001/08/10 12:23:56  slhullier
#
#Begining of protocols modification + HTML correct accents
#
#Revision 1.14  2001/08/01 06:11:17  slhullier
#
#Timeout working
#
#Revision 1.13  2001/07/27 15:06:23  slhullier
#
#Beaf meat tracability ...  (on affiche la machine qui se connecte)
#
#Revision 1.12  2001/07/27 09:50:59  slhullier
#
#Authentification & multi-clients
#
#Revision 1.11  2001/07/27 08:17:11  slhullier
#
#Session-directory creation in the apache module
#
#Revision 1.10  2001/07/24 14:38:41  slhullier
#
#Scripting for Visu
#
#Revision 1.9  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.8  2001/06/26 16:50:54  slhullier
#
#Led sans image, message plus beaux ...
#
#Revision 1.7  2001/06/26 14:14:40  slhullier
#
#Messages d'erreur de ApacheModule plus clairs
#
#Revision 1.6  2001/06/19 16:23:53  slhullier
#
#Les graphs fonctionnent dans la visu (encore 1 petit pb de nom de variable)
#
#Revision 1.5  2001/06/15 08:49:01  slhullier
#
#Modif pour merzhin
#
#Revision 1.4  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::ApacheModule;

use strict;
use Apache::Session::File;
use Apache::Constants ':common';
use Apache::Request;
use IO::Socket;
use IPC::SysV qw(IPC_STAT IPC_PRIVATE IPC_CREAT S_IRUSR S_IWUSR SEM_UNDO IPC_NOWAIT);
use IPC::Semaphore;
use Sys::Hostname;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Request;


# update init file if you modify this variable :
my $directory = '/tmp/logtrend-visu-apache-session';

my $dbmfile   = "$directory/port";

my $visuHost = hostname();
## $visuHost = "visuhost.mydomain.org"; ##
my $visuPort = "10101";

my $key = IPC::SysV::ftok( ".", "]" );
my $semaphore = new IPC::Semaphore( $key, 1, IPC_CREAT | S_IRUSR | S_IWUSR );

##******************************************************************************
## Function handler
##  Description  : treat a request form the user
##  Parameters   : an 'Apache' object
##  Return value : fills the 'Apache' object and return an HTTP status-code
##******************************************************************************
sub handler
{
   my ($request) = @_;  # an 'Apache' object

   ##===========================================================================
   ## The request
   ##===========================================================================
   $request->header_out("Perl-Version" => $]);

   my $url = $request->uri();
   $url .= "/" if( $url eq "/$CstVisuName" );

   my @nodes = split( /\/+/, $url );

   shift @nodes;
   my $visuLogTrend = shift @nodes;

   return error( $request, "$CstVisuName module incoherence", "URL prefixes are different" )
      if( $visuLogTrend ne $CstVisuName );

   my $urlUser = shift @nodes;

   ##===========================================================================
   ## User & remote-host
   ##===========================================================================
   my $user = $request->connection()->user();
   if( ! defined($user) )
   {
      return error( $request, "$CstVisuName module bad installation",
                    "you must install $CstVisuName in an authentification-needed directory".
                    " aimed at distinguishing users from each-others"  );
   }
   if( $user != $urlUser )
   {
      return error( $request, "$CstVisuName module incoherence",
                    "users from URL and from realm are different" );
   }

   my $remoteHost = $request->get_remote_host();
   $remoteHost = "" if( ! defined($remoteHost) );

   ##===========================================================================
   ## From user to socket-port
   ##===========================================================================
   ##------------------------------------------------------------------------
   ## directory creation
   ##------------------------------------------------------------------------
   if( ! -e $directory )
   {
       mkdir("$directory",0700) or
           return error( $request, "Error with <CODE>$directory</CODE> on ".hostname(), "$!" );
   }
   elsif( ! -d $directory )
   {
      return error( $request, "Error with <CODE>$directory</CODE> on ".hostname(),
                    "file exists and is not a directory" );
   }
   elsif( ! -w $directory )
   {
       return error( $request, "Error with <CODE>$directory</CODE> on ".hostname(),
                     "directory exists but can not write" );
   }

   ##------------------------------------------------------------------------
   ## dbmfile open
   ##------------------------------------------------------------------------
   my %ports = ();
   my $port;
   $semaphore->op( 0,0,0,   0,1,SEM_UNDO ) || die "semaphore->op"; # take
   dbmopen(%ports,$dbmfile,0644) or
      return error( $request, "Error with <CODE>$dbmfile</CODE> on ".hostname(), "$!" );
   $port = $ports{$user};
   dbmclose(%ports);
   $semaphore->op( 0,-1,IPC_NOWAIT|SEM_UNDO ) || die "semaphore->op"; # let

   ##===========================================================================
   ## Existing port
   ##===========================================================================
   if( defined $port )
   {
      return RefreshURL($request,$user)  if( $url eq "/$CstVisuName/" );

      return Contact_Existing_Manager( $request, $port, $url, $user, $remoteHost );
   }

   ##===========================================================================
   ## Creation of a new user
   ##===========================================================================
   my $val = NewUserCreation( $request, $user, $remoteHost );
   return $val  if( defined( $val ) );

   return RefreshURL($request,$user);

}

##******************************************************************************
## Function NewUserCreation
##******************************************************************************
sub NewUserCreation
{
   my ( $request, $user, $remoteHost ) = @_;

   ##------------------------------------------------------------------------
   my $sock = new IO::Socket::INET( PeerAddr => $visuHost,
                                    PeerPort => $visuPort,
                                    Proto    => 'tcp' );
   if( !defined $sock )
   {
      return error( $request,
               "No ManagersCreator running on $visuHost:$visuPort",
                     "new IO::Socket::INET to ManagersCreator:$!" );
   }

   ##------------------------------------------------------------------------
   print $sock "<NewConnection User=\"$user\" RemoteHost=\"$remoteHost\"/>\n";
   my $line = <$sock>;
   close $sock;
   if( !defined $line )
   { return error( $request, "ManagersCreator internal error", "socket: no line to read" ); }

   if( $line !~ /<Manager Port="(.*)"\/>/ )
   {
      if( $line !~ /<Error Text="(.*)"\/>/ )
      {
         return error( $request, "ManagersCreator internal error", "socket: bad line to read" );
      }
       return error( $request, "ManagersCreator internal error", "$1" );
   }
   my $port = $1;

   ##------------------------------------------------------------------------
   my %ports = ();
   $semaphore->op( 0,0,0,   0,1,SEM_UNDO ) || die "semaphore->op"; # take
   dbmopen(%ports,$dbmfile,0644) or
      return error( $request, "Error with <CODE>$dbmfile</CODE> on ".hostname(), "$!" );
   foreach my $u (keys %ports)
   {
      delete $ports{$u}  if( $ports{$u} == $port );
   }
   $ports{$user} = $port;
   dbmclose(%ports);
   $semaphore->op( 0,-1,IPC_NOWAIT|SEM_UNDO ) || die "semaphore->op"; # let

   return undef;
}

##******************************************************************************
## Function RefreshURL
##******************************************************************************
sub RefreshURL
{
   my ($request, $user) = @_;
   my $refreshUrl = "/$CstVisuName/$user/";
   $request->content_type("text/html");
   $request->send_http_header;
   $request->print("<HTML>\n");
   $request->print("<HEAD><TITLE> </TITLE></HEAD>\n");
   $request->print("<META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\">\n");
   $request->print("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"1;URL=$refreshUrl\">\n");
   $request->print("<BODY>\n");
   $request->print("<A HREF=\"$refreshUrl\">Click here</A> or wait a second&nbsp;...\n");
   $request->print("</BODY>\n");
   $request->print("</HTML>\n");
   return OK;
}

##******************************************************************************
## Function Contact_Existing_Manager
##******************************************************************************
sub Contact_Existing_Manager
{
   my ($request, $port, $url, $user, $remoteHost) = @_;

   ##---------------------------------------------------------------------------
   my $sock = new IO::Socket::INET( PeerAddr => $visuHost,
                                    PeerPort => $port, Proto => 'tcp' );
   if( !defined( $sock ) )
   {
      my $val = NewUserCreation( $request, $user, $remoteHost );
      return $val  if( defined( $val ) );

      if( !defined( $sock = new IO::Socket::INET( PeerAddr => $visuHost, PeerPort => $port,
                                                  Proto    => 'tcp' ) ) )
      {
         return error( $request, "User persistance problem",
                       "Manager died, then it was reloaded, but it doesn't reply one more time" );
      }
   }

   ##---------------------------------------------------------------------------
   print $sock  LogTrend::Visu::Request::URLtoXML( $url, Apache::Request->new($request) );

   ##---------------------------------------------------------------------------
   my $line = <$sock>;
   if( !defined $line )
   { return error( $request, "SessionManager internal error", "socket: no line to read" ); }
   if( $line !~ /<Response Status="(.*)" Content-Type="(.*)" FileName="(.*)" Quit="(.*)"\/>/ )
   { return error( $request, "SessionManager internal error", "socket: bad line to read" ); }
   my $status = $1;
   my $contentType = $2;
   my $filename = $3;
   my $quit = $4;

   ##---------------------------------------------------------------------------
   $request->content_type($contentType);
   $request->header_out( "Content-Disposition", "attachment; filename=$filename" )
      if( $filename ne "" );
   $request->send_http_header;
   ##    if( $contentType eq "text/html" ) ##
   ##    { $request->print("<META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\">\n"); } ##
   $request->print($_) while(<$sock>);
   close $sock;

   return OK;
}

##******************************************************************************
## Function error
##******************************************************************************
sub error
{
   my ($request,$message,$errno) = @_;
   $request->content_type("text/html");
   $request->send_http_header;
   $request->print("<HTML>\n");
   $request->print("<HEAD><TITLE>Error</TITLE></HEAD>\n");
   $request->print("<META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\">\n");
   $request->print("<BODY>\n");
   $request->print("<CENTER>\n");
   $request->print("<BR><HR WIDTH=\"50%\">\n");
   $request->print("<B>$message</B><BR>\n");
   $request->print("<FONT SIZE=\"-1\">($errno)</FONT><BR>\n") if( defined($errno) );
   $request->print("<HR WIDTH=\"50%\"><BR>\n");
   $request->print("<H2>-&gt; <A HREF=\"/$CstVisuName/\" TARGET=\"_top\">New connection</A> &lt;-</H2><BR>\n");
   $request->print("</CENTER>\n");
   $request->print("</BODY>\n");
   $request->print("</HTML>\n");
   return OK;
}


##******************************************************************************
1;
__END__
