#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Entity.pm,v 1.10 2001/11/19 10:56:54 slhullier Exp $
##******************************************************************************
## Class Entity
##  Description  : correspond to the Entity XML tag
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Entity.pm,v $
#Revision 1.10  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.9  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.8  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.7  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.6  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.5  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.4  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Entity;

use strict;
use XML::DOM;

use LogTrend::Visu::Utils;

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode) = @_;
   my $self = {};
   bless($self, $classname);

   my $attributes = $rootnode->getAttributes() || die("Error in \"Entity\" tag.");
   my $attrnode = $attributes->getNamedItem("Number") ||
                   die("No 'Number' field in \"Entity\" tag.");
   $self->{NUMBER} = AccentsXML2Text( $attrnode->getValue() );

   $self->{OWNER} = $self->{SITUATION} = $self->{DESCRIPTION} = "";

   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Source" )
      { $self->{SOURCE} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Agent" )
      { $self->{AGENTNUMBER} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Name" )
      { $self->{NAME} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "IP_Address" )
      { $self->{IP_ADDRESS} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Owner" )
      { $self->{OWNER} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Situation" )
      { $self->{SITUATION} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Description" )
      { $self->{DESCRIPTION} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }

   }

   die("No Source in Entity XML tag") if( !defined($self->{SOURCE}) );
   die("No Agent in Entity XML tag") if( !defined($self->{AGENTNUMBER}) );
   die("No Name in Entity XML tag") if( !defined($self->{NAME}) );
   die("No IP_Address in Entity XML tag") if( !defined($self->{IP_ADDRESS}) );

   return $self;
}

##******************************************************************************
## Method number  public
##  Description  : returns the number of the Entity
##  Parameters   : none
##  Return value : the number
##******************************************************************************
sub number
{
   my ($self) = @_;
   return $self->{NUMBER};
}

##******************************************************************************
## Method source  public
##  Description  : returns the source of the Entity
##  Parameters   : none
##  Return value : the number
##******************************************************************************
sub source
{
   my ($self) = @_;
   return $self->{SOURCE};
}

##******************************************************************************
## Method agentNumber  public
##  Description  : returns the agent-number of the Entity
##  Parameters   : none
##  Return value : the agent-number
##******************************************************************************
sub agentNumber
{
   my ($self) = @_;
   return $self->{AGENTNUMBER};
}

##******************************************************************************
1;
