#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Expression.pm,v 1.17 2001/12/05 16:32:36 slhullier Exp $
##******************************************************************************
## Class Expression
##  Description  : class to refere to (multiple) data in data base
##                 and to calculate the value of the expression
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr (30.07.2001)
##******************************************************************************
#$Log: Expression.pm,v $
#Revision 1.17  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.16  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.15  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.14  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.13  2001/11/14 13:14:13  slhullier
#*** empty log message ***
#
#Revision 1.12  2001/11/06 14:23:49  lsimonneau
#Add The Discs zone for report.
#Minor bugfixes in Expression.pm
#
#Revision 1.11  2001/10/31 09:31:39  slhullier
#uninitialized value fixed
#
#Revision 1.10  2001/10/30 15:56:10  slhullier
#Expression with '/' char
#
#Revision 1.9  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.8  2001/10/25 14:25:41  slhullier
#First working version for reports
#
#Revision 1.7  2001/10/23 12:19:04  lsimonneau
#Modification for Report support.
#
#Revision 1.6  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.5  2001/09/05 09:00:22  slhullier
#
#LabelsPerLine done
#
#Revision 1.4  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.3  2001/08/03 13:07:27  slhullier
#*** empty log message ***
#
#Revision 1.2  2001/08/02 12:30:44  cnajar
#Method variable added
#
#Revision 1.1  2001/07/30 15:00:45  slhullier
#
#Arithmetic expressions are parsed.
#

package LogTrend::Visu::Expression;

use strict;

use LogTrend::Visu::Utils;

##******************************************************************************
## Constructor  public
##  Parameters   : the XML node
##******************************************************************************
sub new
{
   my ($classname,$node,$systemsDeclaration) = @_;
   my $self = {};
   bless($self, $classname);

   $self->{SYSTEMSDECLARATION} = $systemsDeclaration;
   ##===========================================================================
   my $attributes = $node->getAttributes() || die("Error in \"Expression\" tag.");

   ##===========================================================================
   my $attrnode = $attributes->getNamedItem("Value");
   if( defined( $attrnode ) )
   {
      $self->{EXPRESSION} = AccentsXML2Text( $attrnode->getValue() );

      die( "Bad expression format: '$self->{EXPRESSION}'" )
         if( $self->{EXPRESSION} !~ /^([()*\-+\/ ]|[0-9]+|([0-9]+\.[a-zA-Z][a-zA-Z0-9_]*)|('[0-9]+\.[^']+'))+$/ );

      $attributes->getNamedItem("Canvas") &&
         die("'Value' and 'Canvas' fields in \"Expression\" tag.");
   }
   else
   {
      $attrnode = $attributes->getNamedItem("Canvas") ||
         die("No 'Value' nor 'Canvas' field in \"Expression\" tag.");
      $self->{CANVAS} = AccentsXML2Text( $attrnode->getValue() );
   }

   ##===========================================================================
   $attrnode = $attributes->getNamedItem("Label");
   if(    defined( $attrnode ) )           { $self->{LABEL} = $attrnode->getValue(); }
   elsif( defined( $self->{EXPRESSION} ) ) { $self->{LABEL} = $self->{EXPRESSION}; }
   elsif( defined( $self->{CANVAS} ) )     { $self->{LABEL} = $self->{CANVAS}; }
   else                                    { $self->{LABEL} = ""; }

   $self->{LABEL} = AccentsXML2Text( $self->{LABEL} );

   ##===========================================================================
   $attrnode = $attributes->getNamedItem("Color");
   $self->{COLOR} = AccentsXML2Text($attrnode->getValue()) if( defined( $attrnode ) );

   ##===========================================================================
   $self->{DATABASE} = undef;

   return $self;
}

##******************************************************************************
## Method propagateInfos  public
##  Description  : propagates some informations to containned objects
##                 (makes links from Expression to Canvas)
##  Parameters   : a reference on the Canvas hash-table of the SystemLeaf
##  Return value : none
##******************************************************************************
sub propagateInfos
{
   my ($self,$canvasHash) = @_;

   ##===========================================================================
   if( defined( $self->{EXPRESSION} ) )
   {
      my $expr = $self->{EXPRESSION};
      my $alreadyDone = "#";
      my $count = 0;
      my $c;

      for my $variable ($expr =~ /([0-9]+\.[a-zA-Z][a-zA-Z0-9_]*)|('[0-9]+\.[^']+')/g)
      {
         next if( (!defined($variable)) or ($variable eq "") );

         my ($canvas,$databasevar) = ($variable=~/'?(.*)\.([^']*)'?/);
         my $canonicalVariable = "$canvas.$databasevar";
         next if( $alreadyDone =~ /#$canonicalVariable#/ );
         $alreadyDone .= "$canonicalVariable#";

         die("Expression: no such Canvas '$canvas'")
            if( !defined( $canvasHash->{ $canvas } ) );
         $c = $canvasHash->{ $canvas };
         $self->{"${count}_SRC"} = $c->source();
         $self->{"${count}_AGT"} = $c->agentNumber();
         $self->{"${count}_VAR"} = $databasevar;

         $expr =~ s/\'$canonicalVariable\'/v$count/g;
         $expr =~ s/$canonicalVariable/v$count/g;
         $count++;
      }

      $self->{NB_VAR} = $count;
      $self->{EXPRESSION} = $expr;

   }
   ##===========================================================================
   else   # $self->{CANVAS} is defined
   {
      die("Expression: no such $self->{CANVAS} Canvas")
         if( !defined( $canvasHash->{ $self->{CANVAS} } ) );
      my $c = $canvasHash->{ $self->{CANVAS} };
      $self->{"0_SRC"} = $c->source();
      $self->{"0_AGT"} = $c->agentNumber();
   }

}

##******************************************************************************
## Method setDataBase  protected
##  Description  : get the database from the systemsDeclaration
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub setDataBase
{
   my ($self) = @_;
   $self->{DATABASE} = $self->{SYSTEMSDECLARATION}->getDataBase();
}

##******************************************************************************
## Method evalLast  public
##  Description  : eval the expression for the last values
##  Parameters   : none
##  Return value : the value of the expression
##******************************************************************************
sub evalLast
{
   my ($self) = @_;

   die("Bad Expression Value used") if( !defined($self->{EXPRESSION}));

   $self->setDataBase() if( !defined($self->{DATABASE} ) );

   my $expr = $self->{EXPRESSION};
   my $r;
   for( my $count=0; $count<$self->{NB_VAR}; $count++ )
   {
      $r = $self->{DATABASE}->GetData( $self->{"${count}_SRC"}, $self->{"${count}_AGT"},
                               $self->{"${count}_VAR"} );
      return undef if( $r eq "0" || !defined($r->[0]) );

      $expr =~ s/v$count/$r->[0]/g;
   }

   {
      eval "\$r = $expr";
   }

   return undef if $@;
   return $r;
}


##******************************************************************************
## Method evalInTimeInterval  public
##  Description  : eval the expression for a time interval
##  Parameters   : none
##  Return value : the value of the expression
##******************************************************************************
sub evalInTimeInterval
{
   my ($self,$limit,$start,$stop) = @_;

   die("Bad Expression Value used") if( !defined($self->{EXPRESSION}));

   $self->setDataBase() if( !defined($self->{DATABASE} ) );

   ##===========================================================================
   ## Getting data
   ##===========================================================================
   my %data = ();
   my $r;
   for( my $count=0; $count<$self->{NB_VAR}; $count++ )
   {
      $r = $self->{DATABASE}->GetDataInRelativeTimeInterval( $limit,
              $self->{"${count}_SRC"}, $self->{"${count}_AGT"}, $self->{"${count}_VAR"},
              $start, $stop );
      return "0" if( $r eq "0" );

      foreach my $d (@$r)
      {
         @{$data{$d->[1]}} = \()  if( !defined( $data{$d->[1]} ) );
         $data{$d->[1]}->[$count] = $d->[0];
      }
      $r = undef;
   }

   ##===========================================================================
   ## Computing data
   ##===========================================================================
   my @result = ();
   my $expr = $self->{EXPRESSION};
   my $e;
   TIME: foreach my $time (sort( {$a<=>$b} keys(%data)))
   {
      $e = $expr;
      for( my $count=0; $count<$self->{NB_VAR}; $count++ )
      {
         next TIME if( !defined( $data{$time}->[$count] ) );
         $e =~ s/v$count/$data{$time}->[$count]/g;
      }

      {
         eval "\$r = $e";
      }
      next if $@;

      my @couple = ($r,$time);
      push @result, \@couple;

   }

   return \@result;
}


##******************************************************************************
## Method evalInAbsoluteTimeInterval  public
##  Description  : eval the expression for a absolute time interval
##  Parameters   : none
##  Return value : the value of the expression
##******************************************************************************
sub evalInAbsoluteTimeInterval
{
   my ($self,$limit,$start,$stop) = @_;

   die("Bad Expression Value used") if( !defined($self->{EXPRESSION}));

   $self->setDataBase() if( !defined($self->{DATABASE} ) );

   ##===========================================================================
   ## Getting data
   ##===========================================================================
   my %data = ();
   my $r;
   for( my $count=0; $count<$self->{NB_VAR}; $count++ )
   {
      $r = $self->{DATABASE}->GetDataInTimeInterval( $limit,
              $self->{"${count}_SRC"}, $self->{"${count}_AGT"}, $self->{"${count}_VAR"},
              $start, $stop );

      return "0" if( $r eq "0" );

      foreach my $d (@$r)
      {
         @{$data{$d->[1]}} = \()  if( !defined( $data{$d->[1]} ) );
         $data{$d->[1]}->[$count] = $d->[0];
      }
      $r = undef;
   }

   ##===========================================================================
   ## Computing data
   ##===========================================================================
   my @result = ();
   my $expr = $self->{EXPRESSION};
   my $e;
   TIME: foreach my $time (sort( {$a<=>$b} keys(%data)))
   {
      $e = $expr;
      for( my $count=0; $count<$self->{NB_VAR}; $count++ )
      {
         next TIME if( !defined( $data{$time}->[$count] ) );
         $e =~ s/v$count/$data{$time}->[$count]/g;
      }

      {
         eval "\$r = $e";
      }
      next if $@;

      my @couple = ($r,$time);
      push @result, \@couple;

   }

   return \@result;
}


##******************************************************************************
## Methods  public
##  Description  : return object field
##  Parameters   : none
##  Return value : the value
##******************************************************************************
sub source   { return $_[0]->{"0_SRC"}; }
sub agent    { return $_[0]->{"0_AGT"}; }
sub variable { return $_[0]->{"0_VAR"}; }

sub label    { return $_[0]->{"LABEL"}; }
sub color    { return $_[0]->{"COLOR"}; }

##******************************************************************************
1;
