#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/ReportGenerator.pm,v 1.14 2002/01/04 16:06:55 slhullier Exp $
##******************************************************************************
## Class ReportGenerator
##  Description  : class to create reports
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: ReportGenerator.pm,v $
#Revision 1.14  2002/01/04 16:06:55  slhullier
#/etc/init.d/LogTrendVisu report generation bug solved
#
#Revision 1.13  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.12  2001/11/26 15:52:31  slhullier
#User inclusion for admin user seems to be ok
#
#Revision 1.11  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.10  2001/11/19 12:24:24  slhullier
#Accents ok for 5.5.3 and 5.6.1
#
#Revision 1.9  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.8  2001/11/13 10:37:41  slhullier
#Accents bug for on-line reports fixed
#
#Revision 1.7  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.6  2001/10/30 09:42:34  slhullier
#Report via the web: minimalist
#
#Revision 1.5  2001/10/30 08:47:12  slhullier
#*** empty log message ***
#
#Revision 1.4  2001/10/30 08:02:19  slhullier
#Trying to fix accents bug
#
#Revision 1.3  2001/10/29 14:06:03  slhullier
#Stable but non-realy working report via the web
#
#Revision 1.2  2001/10/25 14:25:41  slhullier
#First working version for reports
#
#Revision 1.1  2001/10/24 12:00:39  slhullier
#First version for report-generation
#

package LogTrend::Visu::Report::ReportGenerator;

use strict;
use XML::DOM;
use POSIX qw(tmpnam);
use File::Copy;

use LogTrend::Common::LogDie;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Request;
use LogTrend::Visu::Utils;
use LogTrend::Visu::Report::SystemsDeclaration;

##******************************************************************************
## Constructor  public
##  Parameters   : the user, the XML file-name, an optional ref on hash-table
##                 with form values
##******************************************************************************
sub new
{
   my ($classname,$user,$confFilename,$param) = @_;
   my $self = {};
   bless($self, $classname);

   $self->{USER} = $user;
   $self->parseConfXML($confFilename);
   $self->{SYSTEMSDECLARATION} =
       new LogTrend::Visu::Report::SystemsDeclaration($user,$param);

   return $self;
}

##******************************************************************************
## Method parseConfXML  public
##  Description  : parse configuration XML file
##  Parameters   : the filename
##  Return value : none (side effect: affects some variables into $self)
##******************************************************************************
sub parseConfXML
{
   my ($self,$file) = @_;

   my $parser = new XML::DOM::Parser() || die($!);
   open( FILE, "$file" ) || die("$file: $!");
   close(FILE);
   my $doc = $parser->parsefile( $file ) || die("$file: $!");

   my $rootlist = $doc->getElementsByTagName("ReportConf") ||
                                         die("No \"ReportConf\" tag.");
   my $rootnode = $rootlist->item(0) || die("No \"ReportConf\" tag.");

   ##===========================================================================
   my $list = $rootnode->getElementsByTagName("Dsssl") ||
                                               die("file $file: No \"Dsssl\" tag.");
   my $node = $list->item(0) || die("file $file: No \"Dsssl\" tag.");
   my $attributes = $node->getAttributes() || die("file $file: Error in \"Dsssl\" tag.");

   ##---------------------------------------------------------------------------
   my $attrnode = $attributes->getNamedItem("Path") ||
                                   die("file $file: No 'Path' field in \"Dsssl\" tag.");
   $self->{DSSSL} = $attrnode->getValue();

   $doc->dispose();
   $doc = $parser = undef;

}

##******************************************************************************
## Method run  public
##  Description  : run the ReportGenerator
##  Parameters   : the dsssl directory
##  Return value : the content of the .tar.gz file result
##******************************************************************************
sub run
{
   my ($self) = @_;

   ##===========================================================================
   ## Directories
   ##===========================================================================
   my $directory = tmpnam();
   mkdir($directory,0700) or Die("$directory: $!");
   chdir($directory) or Die("$directory: $!");

   my $dirName = "report";
   mkdir($dirName,0777) or Die("$directory/$dirName: $!");
   chdir($dirName) or Die("$directory/$dirName: $!");

   ##===========================================================================
   ## File report.sgml
   ##===========================================================================
   my $fileName = "report.sgml";
   open(REPORT,">$fileName") or Die("$directory/$dirName/$fileName: $!");
 
   my $text = $self->{SYSTEMSDECLARATION}->buildTree( );
   print REPORT $text;
   close(REPORT);

   ##===========================================================================
   ## Others files
   ##===========================================================================
   my @othersFiles = ( "logtrend.dsl", "global.ent", "logo_logtrend.eps",
                       "titlepage.dsl", "eye.eps", "Makefile" );

   foreach my $f (@othersFiles)
   {
      copy("$self->{DSSSL}/$f","./$f") or Die("copy: $!");
   }

   ##===========================================================================
   ## Tar.gz
   ##===========================================================================
   chdir($directory) or Die("$directory: $!");

   my $pid;
   if( $pid = fork() )
   {
      my $r = waitpid($pid,0);
      die("waitpid : $!") if( $r == -1 );
   }
   elsif( defined($pid) )
   {
      exec( 'sh', '-c', "/bin/tar cfz $dirName.tar.gz $dirName >/dev/null 2>/dev/null" );
      die("exec : $!");
   }
   else
   {
      die("fork : $!");
   }

   ##===========================================================================
   ## Unlink
   ##===========================================================================
   opendir(DIR,"$directory/$dirName") or Die("opendir $directory/$dirName: $!");
   foreach my $name (grep !/^\.\.?$/, readdir DIR)
   {
      unlink("$directory/$dirName/$name") or Die("unlink $directory/$dirName/$name: $!");
   }
   closedir(DIR);
   rmdir("$directory/$dirName") or Die("rmdir $directory/$dirName: $!");

   ##===========================================================================
   my $result = "";
   open(FILE,"<$directory/$dirName.tar.gz") or Die("open $directory/$dirName.tar.gz: $!");
   while(<FILE>){ $result .= $_; }
   close(FILE);

   unlink("$directory/$dirName.tar.gz") or Die("unlink $directory/$dirName.tar.gz: $!");
   rmdir("$directory") or Die("rmdir $directory: $!");

   return $result;

}

##******************************************************************************
1;
