#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/SystemLeaf.pm,v 1.8 2001/11/14 14:13:48 slhullier Exp $
##******************************************************************************
## Class SystemLeaf  isa LogTrend::Visu::SystemLeaf isa ArchitectureNode
##  Description  : class for system (correspond to System XML tag)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: SystemLeaf.pm,v $
#Revision 1.8  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.7  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.6  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.5  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.4  2001/10/26 12:38:05  slhullier
#*** empty log message ***
#
#Revision 1.3  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.2  2001/10/26 11:52:43  slhullier
#test
#
#Revision 1.1  2001/10/24 12:00:39  slhullier
#First version for report-generation
#

package LogTrend::Visu::Report::SystemLeaf;

use strict;

use LogTrend::Visu::Canvas;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Constants;
use LogTrend::Visu::Report::VisuClass;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::SystemLeaf");

##******************************************************************************
## Constructor  public
##  Parameters   : the root node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$systemsDeclaration);

   return undef if( !defined($self) ); # some systems are not wanted for reports or web

   bless($self, $classname);
   return $self;
}

##******************************************************************************
sub newVisuClass
{
   my ($self,$kid,$systemsDeclaration) = @_;
   return new LogTrend::Visu::Report::VisuClass( $kid, $systemsDeclaration );
}

##******************************************************************************
## Method buildTree  public >LogTrend::Visu::SystemLeaf >ArchitectureNode
##  Description  : put this object in an HTML tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self,$dir) = @_;
   my $result = "";

   if( (length($dir)==0) or (length($dir)==4) ) { $result .= "<chapter>\n"; }
   else                                         { $result .= "<section>\n"; }

   $result .= "    <title>$self->{NAME}</title>\n";

   $result .= $self->{CLASS}->buildTree( );

   if( (length($dir)==0) or (length($dir)==4) ) { $result .= "</chapter>\n"; }
   else                                         { $result .= "</section>\n"; }

   return $result;
}

##******************************************************************************
1;
