#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Report/Zone/Discs.pm,v 1.8 2001/11/19 12:55:50 slhullier Exp $
##******************************************************************************
## Class Discs  isa Zone
##  Description  : class for printing messages
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Discs.pm,v $
#Revision 1.8  2001/11/19 12:55:50  slhullier
#Accent bug fixed at all ...
#
#Revision 1.7  2001/11/16 14:49:21  slhullier
#arg bug fixed ?
#
#Revision 1.6  2001/11/14 15:59:45  slhullier
#No more global value for SystemsDeclaration
#
#Revision 1.5  2001/11/12 10:03:00  slhullier
#no more tab
#
#Revision 1.4  2001/11/09 13:42:42  slhullier
#Duration/Interval/StartStop modification
#
#Revision 1.3  2001/11/07 16:05:26  lsimonneau
#*** empty log message ***
#
#Revision 1.2  2001/11/06 17:47:05  lsimonneau
#Move Duration and Start/Stop to a Time tag.
#No backward compatibility.
#
#Revision 1.1  2001/11/06 16:01:54  lsimonneau
#First release.
#


package LogTrend::Visu::Report::Zone::Discs;

use strict;

use POSIX qw(strftime);
use Time::Local;
use LogTrend::Common::Duration;
use LogTrend::Visu::TimeUtils;
use LogTrend::Visu::Zone;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use XML::DOM;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::Zone");

##******************************************************************************
## Constructor  public
##  Description  : creat a new Discs object
##  Parameters   : the Zone XML node
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$realrootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new($rootnode,$realrootnode,$systemsDeclaration);
   bless($self, $classname);

   my ($list,$node,$attributes,$attrnode);

   $list = $rootnode->getElementsByTagName("Time") || die("Error in \"Discs\".");
   die("Error in \"Discs\".") if (@$list == 0);
   $node = $list->[0];
   $attributes = $node->getAttributes() || die("Error in \"Discs\".");

   ##===========================================================================
   ## Discs tag
   ##===========================================================================
   my $now = time;
   $attrnode = $attributes->getNamedItem("Duration");
   if( defined( $attrnode ) )
   {
      $self->{ORIGINAL_START} = Duration( $attrnode->getValue() );
      $self->{ORIGINAL_STOP}  = 0;
      $self->{USE_ABSOLUTE_DATE} = 0;
   }
   ##---------------------------------------------------------------------------
   elsif( defined( $attrnode = $attributes->getNamedItem("Interval") ) )
   {
      ($self->{ORIGINAL_START},$self->{ORIGINAL_STOP}) =
         TimeInterval( $attrnode->getValue() );
      $self->{USE_ABSOLUTE_DATE} = 1;
   }
   ##---------------------------------------------------------------------------
   else
   {
      $attrnode = $attributes->getNamedItem("Start") or
         die("No 'Start' field in \"X\" tag.");
      my $start_val = AccentsXML2Text( $attrnode->getValue() );

      $attrnode = $attributes->getNamedItem("Stop") or
         die("No 'Stop' field in \"X\" tag.");
      my $stop_val = AccentsXML2Text( $attrnode->getValue() );

      ($self->{ORIGINAL_START},$self->{ORIGINAL_STOP},$self->{USE_ABSOLUTE_DATE}) =
         StartStop( $start_val, $stop_val );
   }

   return $self;
}


sub propagateInfos {
    my ($self, $canvas, $screenXmlId, $colsize) = @_;

    $self->SUPER::propagateInfos($canvas, $screenXmlId, $colsize);

    my $devices = $self->getDevices;

    foreach my $dev (@$devices) {
        $self->{GRAPH}->{$dev} = $self->createGraph($dev);

        $self->{GRAPH}->{$dev}->propagateInfos($canvas, $screenXmlId, $colsize);
    }

}

##******************************************************************************
## Method getDevices
##  Description  : Retrieve discs data
##  Parameters   : none
##  Return value : none
##******************************************************************************
sub getDevices
{
   my $self = shift;

   ##===========================================================================
   ## Determins the devices
   ##===========================================================================
   my $dataBase = $self->{SYSTEMSDECLARATION}->getDataBase();
   my $expression = $self->{EXPRESSIONS}->[0];

   my @devices = ();
   my $varName = $dataBase->GetListOfDataNameOnAgent( $expression->source(),
                                                      $expression->agent() );
   if( $varName ne "0" )
   {
      foreach my $vn (@$varName)
      {
         if( $vn =~ /^free_space_on_(.*)/ )
         {
            unshift @devices, $1;
         }
      }
   }

   @devices = sort(@devices);
   return \@devices;
}

##******************************************************************************
## Method treat  public >Zone
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
   my ($self) = @_;
   my $response = new LogTrend::Visu::Response();

   my $dataBase = $self->{SYSTEMSDECLARATION}->getDataBase();

   my $expression = $self->{EXPRESSIONS}->[0];

   $response->contentType("text/sgml");
   $response->print("<title>$self->{TITLE}</title>\n");

   my @devices = keys %{$self->{GRAPH}};

   if(@devices == 0) {
       $response->print("<para> No data </para>\n");
   }
   else {
       foreach my $dev (@devices) {
           $response->print("<section>\n");
           my $graph_resp = $self->{GRAPH}->{$dev}->treat;
           $response->print($graph_resp->getContent );
           $response->print("</section>\n");
       }
   }


   return $response;
}


sub createGraph {
    my ($self, $dev) = @_;

    my $xml_data = "
<Zone>
   <Title>Used space on $dev</Title>
   <Position x=\"0\" y=\"0\" width=\"2\" height=\"2\"/>
      <Type>
         <LineGraph>\n";

    if($self->{USE_ABSOLUTE_DATE}) {
        my $start = strftime("%d/%m/%Y %H:%M:%S", localtime($self->{ORIGINAL_START}));
        my $stop = strftime("%d/%m/%Y %H:%M:%S", localtime($self->{ORIGINAL_STOP}));
        $xml_data .= "<X  Start=\"$start\" Stop=\"$stop\" />\n";
    }
    else {
        $xml_data .= "<X  Start=\"$self->{ORIGINAL_START}\" Stop=\"$self->{ORIGINAL_STOP}\" />\n";
    }

    $xml_data .="<Y  LowerBoundary=\"-5\" UpperBoundary=\"105\" />\n";

    $xml_data .= "</LineGraph>\n</Type>\n<Data>\n";
    my $canvas = $self->{EXPRESSIONS}->[0]->{CANVAS};

    $xml_data .= "<Expression Value=\"'$canvas.used_space_on_$dev'\"\n".
                   "            Label=\"Percent used on $dev\"/>\n";
    $xml_data .= "</Data>\n</Zone>\n";

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parse($xml_data);
    my $root = $doc->getElementsByTagName('Zone');

    my $graph = LogTrend::Visu::Zone->newZone($root->[0], $self->{SYSTEMSDECLARATION},
                                              0, "Report");

    return $graph;
}


##******************************************************************************
1;
