#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Request.pm,v 1.14 2001/11/28 17:29:05 slhullier Exp $
##******************************************************************************
## Class Request
##  Description  : class to stock the request from the client
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Request.pm,v $
#Revision 1.14  2001/11/28 17:29:05  slhullier
#No more session ...
#
#Revision 1.13  2001/11/27 16:04:51  slhullier
#User added in URL
#
#Revision 1.12  2001/08/14 14:25:22  slhullier
#
#Graph zoom : navigation is possible
#
#Revision 1.11  2001/08/13 15:02:18  slhullier
#
#CGI parameters communication via XML protocols
#
#Revision 1.10  2001/08/10 14:47:29  slhullier
#
#Begining of URL XML-encoding ; stable but not finished
#
#Revision 1.9  2001/08/10 12:23:56  slhullier
#
#Begining of protocols modification + HTML correct accents
#
#Revision 1.8  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.7  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.6  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.5  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Request;

use strict;
use LogTrend::Visu::Constants;

##******************************************************************************
## Constructor  public
##  Parameters   : file handle where to read the XML representation of the object
##******************************************************************************
sub new
{
   my ($classname,$handle) = @_;
   my $self = {};
   bless($self, $classname);

   my $line;

   $line = <$handle>;
   return "No Request tag" if( !defined($line) or $line !~ /^<Request>/ );

   $line = <$handle>;
   return "No /Request tag" if( !defined($line) );
   $self->{NODES} = [];
   while( defined($line) and $line =~ /<Node>(.*)<\/Node>/ )
   {
      $self->addNode( $1 );
      $line = <$handle>;
   }
   return "No /Request tag" if( !defined($line) );

   $self->{PARAMS} = {};
   while( defined($line) and $line =~ /<Param Var="(.*)" Val="(.*)"\/>/ )
   {
      $self->param( $1, $2 );
      $line = <$handle>;
   }

   return "No /Request tag" if( !defined($line) or $line !~ /^<\/Request>/ );

   $self->{POSITION} = [];
   return $self;

}

##******************************************************************************
## Method addNode  public
##  Description  : add a node to the object
##  Parameters   : the node value
##  Return value : none
##******************************************************************************
sub addNode
{
   my ($self,$node) = @_;
   my $nodes = $self->{NODES};
   push @$nodes, $node;
}

##******************************************************************************
## Method param  public
##  Description  : set/get the variable value
##  Parameters   : the variable, an optional value
##  Return value : the value
##******************************************************************************
sub param
{
   my ($self,$variable,$value) = @_;
   if( defined($value) )
   {
      $self->{PARAMS}->{$variable} = $value;
   }
   return $self->{PARAMS}->{$variable};
}

##******************************************************************************
## Method URLtoXML  static public
##  Description  : converts an URL into XML (used by ApacheModule)
##  Parameters   : the URL, the Apache::Request object
##  Return value : the XML string
##******************************************************************************
sub URLtoXML
{
   my ($url,$apr) = @_;
   my $result = "";

   my @nodes = split( /\/+/, $url );
   shift @nodes;
   my $visuLogTrend = shift @nodes;
   if( $visuLogTrend ne $CstVisuName )
   {
      $! = "$CstVisuName module incoherence : URL prefixes are different";
      return;
   }

   my $user = shift @nodes;

   $result .= "<Request>\n";

   foreach my $n (@nodes)
   {
      $result .= "<Node>$n</Node>\n";
   }

   my @params = $apr->param();
   foreach my $p (@params)
   {
      $result .= "<Param Var=\"$p\" Val=\"".$apr->param($p)."\"/>\n";
   }

   $result .= "</Request>\n";
   return $result;
}

##******************************************************************************
## Method wantedContent  public
##  Description  : set/return the wanted content
##  Parameters   : an optional wanted content
##  Return value : the wanted content
##******************************************************************************
sub wantedContent
{
   my ($self,$wantedContent) = @_;
   if( defined($wantedContent) )
   {
      $self->{WANTEDCONTENT} = $wantedContent;
   }
   return $self->{WANTEDCONTENT};
}

##******************************************************************************
## Method firstNodeExists  public
##  Description  : return whatever the first node exists
##  Parameters   : none
##  Return value : 1 or 0
##******************************************************************************
sub firstNodeExists
{
   my ($self) = @_;
   my $nodes = $self->{NODES};
   if( defined( $nodes->[0] ) )
   { return 1; }
   return 0;
}

##******************************************************************************
## Method firstNode  public
##  Description  : return the first node
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub firstNode
{
   my ($self) = @_;
   my $nodes = $self->{NODES};
   return $nodes->[0];
}

##******************************************************************************
## Method shiftNodes  public
##  Description  : delete the first node of the list
##  Parameters   : none
##  Return value : the first node
##******************************************************************************
sub shiftNodes
{
   my ($self) = @_;
   my $nodes = $self->{NODES};
   my $position = $self->{POSITION};
   my $n = shift @$nodes;
   push @$position, $n;
   return $n;
}

##******************************************************************************
1;
