#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/Response.pm,v 1.8 2001/12/27 17:10:25 slhullier Exp $
##******************************************************************************
## Class Response
##  Description  : class to stock the response from the server
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: Response.pm,v $
#Revision 1.8  2001/12/27 17:10:25  slhullier
#Plugins 1st step
#
#Revision 1.7  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.6  2001/06/29 13:18:50  slhullier
#
#Petite retouches avant premiere version 'stable'
#
#Revision 1.5  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.4  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::Response;

use strict;

##******************************************************************************
## Constructor  public
##  Parameters   : an optional content-type
##******************************************************************************
sub new
{
   my ($classname,$contentType) = @_;
   my $self = {};
   bless($self, $classname);
   if(!defined($contentType))
   { $contentType = ""; }
   $self->{CONTENTTYPE} = $contentType;
   $self->{FILENAME}    = "";
   $self->{CONTENT}     = "";
   $self->{QUIT}        = 0;
   return $self;
}

##******************************************************************************
## Method contentType  public
##  Description  : set/return the content-type
##  Parameters   : an optional content-type
##  Return value : the content-type
##******************************************************************************
sub contentType
{
   my ($self,$contentType) = @_;
   if( defined($contentType) )
   {
      $self->{CONTENTTYPE} = $contentType;
   }
   return $self->{CONTENTTYPE};
}

##******************************************************************************
## Method fileName  public
##******************************************************************************
sub fileName
{
   my ($self,$fileName) = @_;
   if( defined($fileName) )
   {
      $self->{FILENAME} = $fileName;
   }
   return $self->{FILENAME};
}

##******************************************************************************
## Method quit  public
##  Description  : set/return the quit-flag
##  Parameters   : an optional quit-flag
##  Return value : the quit-flag
##******************************************************************************
sub quit
{
   my ($self,$quitFlag) = @_;
   if( defined($quitFlag) )
   {
      $self->{QUIT} = $quitFlag;
   }
   return $self->{QUIT};
}

##******************************************************************************
## Method print  public
##  Description  : add a content
##  Parameters   : a string to add to the content
##  Return value : none
##******************************************************************************
sub print
{
   my ($self,$text) = @_;
   $self->{CONTENT} .= $text
}

##******************************************************************************
## Method getContent  public
##  Description  : prints the objet into a string
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub getContent
{
   my $self = shift;
   return $self->{CONTENT};
}

##******************************************************************************
1;

